/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

abstract class ImmutableStack<A>
implements Iterable<A> {
    ImmutableStack() {
    }

    final ImmutableStack<A> push(A a) {
        return new Node<A>(a, this);
    }

    abstract Maybe<A> head();

    abstract ImmutableStack<A> tail();

    final boolean isEmpty() {
        return ((Maybe)this.head().fmap((Function)Constantly.constantly(false))).orElse(true);
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private ImmutableStack<A> stack;
            {
                this.stack = ImmutableStack.this;
            }

            @Override
            public boolean hasNext() {
                return !this.stack.isEmpty();
            }

            @Override
            public A next() {
                Object next = this.stack.head().orElseThrow(NoSuchElementException::new);
                this.stack = this.stack.tail();
                return next;
            }
        };
    }

    public static <A> ImmutableStack<A> empty() {
        return Empty.INSTANCE;
    }

    private static final class Node<A>
    extends ImmutableStack<A> {
        private final A head;
        private final ImmutableStack<A> tail;

        public Node(A head, ImmutableStack<A> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        Maybe<A> head() {
            return Maybe.just(this.head);
        }

        @Override
        ImmutableStack<A> tail() {
            return this.tail;
        }
    }

    private static final class Empty<A>
    extends ImmutableStack<A> {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        Maybe<A> head() {
            return Maybe.nothing();
        }

        @Override
        ImmutableStack<A> tail() {
            return this;
        }
    }
}

