/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.iteration.MappingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public final class MappingIterable<A, B>
implements Iterable<B> {
    private final Iterable as;
    private final List<Function> mappers;

    public MappingIterable(Function<? super A, ? extends B> fn, Iterable<A> as) {
        ArrayList<Function<A, B>> mappers = new ArrayList<Function<A, B>>(Collections.singletonList(fn));
        while (as instanceof MappingIterable) {
            MappingIterable nested = (MappingIterable)as;
            as = nested.as;
            mappers.addAll(0, nested.mappers);
        }
        this.as = as;
        this.mappers = mappers;
    }

    @Override
    public Iterator<B> iterator() {
        Function<Object, Object> fnComposedOnTheHeap = o -> FoldLeft.foldLeft((x, fn) -> fn.apply(x), o, this.mappers);
        return new MappingIterator<Object, Object>(fnComposedOnTheHeap, this.as.iterator());
    }
}

