/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.functions.builtin.fn2.Any;
import com.jnape.palatable.lambda.iteration.PredicatedDroppingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public final class PredicatedDroppingIterable<A>
implements Iterable<A> {
    private final List<Function<? super A, Boolean>> predicates;
    private final Iterable<A> as;

    public PredicatedDroppingIterable(Function<? super A, Boolean> predicate, Iterable<A> as) {
        ArrayList<Function<A, Boolean>> predicates = new ArrayList<Function<A, Boolean>>(Collections.singletonList(predicate));
        while (as instanceof PredicatedDroppingIterable) {
            PredicatedDroppingIterable nested = (PredicatedDroppingIterable)as;
            as = nested.as;
            predicates.addAll(nested.predicates);
        }
        this.predicates = predicates;
        this.as = as;
    }

    @Override
    public Iterator<A> iterator() {
        Function<Object, Boolean> metaPredicate = a -> Any.any(p -> (Boolean)p.apply(a), this.predicates);
        return new PredicatedDroppingIterator<Object>(metaPredicate, this.as.iterator());
    }
}

