/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import com.jnape.palatable.lambda.iteration.RewindableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class PredicatedDroppingIterator<A>
extends ImmutableIterator<A> {
    private final Function<? super A, Boolean> predicate;
    private final RewindableIterator<A> rewindableIterator;
    private boolean finishedDropping;

    public PredicatedDroppingIterator(Function<? super A, Boolean> predicate, Iterator<A> asIterator) {
        this.predicate = predicate;
        this.rewindableIterator = new RewindableIterator<A>(asIterator);
        this.finishedDropping = false;
    }

    @Override
    public boolean hasNext() {
        this.dropElementsIfNecessary();
        return this.rewindableIterator.hasNext();
    }

    @Override
    public A next() {
        if (this.hasNext()) {
            return this.rewindableIterator.next();
        }
        throw new NoSuchElementException();
    }

    private void dropElementsIfNecessary() {
        while (this.rewindableIterator.hasNext() && !this.finishedDropping) {
            if (this.predicate.apply(this.rewindableIterator.next()).booleanValue()) continue;
            this.rewindableIterator.rewind();
            this.finishedDropping = true;
        }
    }
}

