/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PrependingIterator<A>
extends ImmutableIterator<A> {
    private final A antecedent;
    private final Iterator<A> iterator;
    private boolean prependNext;

    public PrependingIterator(A antecedent, Iterator<A> iterator) {
        this.antecedent = antecedent;
        this.iterator = iterator;
        this.prependNext = true;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public A next() {
        if (!this.iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prependNext = !this.prependNext;
        return this.prependNext ? this.iterator.next() : this.antecedent;
    }
}

