/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.iteration;

import com.jnape.palatable.lambda.iteration.ImmutableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class ReversingIterator<A>
extends ImmutableIterator<A> {
    private final Iterator<A> as;
    private final ListIterator<A> reversingIterator;

    public ReversingIterator(Iterator<A> as) {
        this.as = as;
        this.reversingIterator = new ArrayList().listIterator();
    }

    @Override
    public boolean hasNext() {
        return this.readyToReverse() ? this.reversingIterator.hasPrevious() : this.as.hasNext();
    }

    @Override
    public A next() {
        if (!this.readyToReverse()) {
            this.prepareForReversal();
        }
        return this.reversingIterator.previous();
    }

    private void prepareForReversal() {
        while (this.as.hasNext()) {
            this.reversingIterator.add(this.as.next());
        }
    }

    private boolean readyToReverse() {
        return this.reversingIterator.hasNext() || this.reversingIterator.hasPrevious();
    }
}

