/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens;

import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Both;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.lens.LensLike;
import com.jnape.palatable.lambda.lens.functions.Over;
import com.jnape.palatable.lambda.lens.functions.Set;
import com.jnape.palatable.lambda.lens.functions.View;
import com.jnape.palatable.lambda.monad.Monad;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface Lens<S, T, A, B>
extends LensLike<S, T, A, B, Lens> {
    default public <U> Lens<S, U, A, B> fmap(Function<? super T, ? extends U> fn) {
        return (Lens)LensLike.super.fmap((Function)fn).coerce();
    }

    default public <U> Lens<S, U, A, B> pure(U u) {
        return Lens.lens(View.view(this), (s, b) -> u);
    }

    default public <U> Lens<S, U, A, B> zip(Applicative<Function<? super T, ? extends U>, LensLike<S, ?, A, B, Lens>> appFn) {
        return (Lens)LensLike.super.zip(appFn).coerce();
    }

    default public <U> Lens<S, U, A, B> discardL(Applicative<U, LensLike<S, ?, A, B, Lens>> appB) {
        return (Lens)LensLike.super.discardL(appB).coerce();
    }

    default public <U> Lens<S, T, A, B> discardR(Applicative<U, LensLike<S, ?, A, B, Lens>> appB) {
        return (Lens)LensLike.super.discardR(appB).coerce();
    }

    default public <U> Lens<S, U, A, B> flatMap(Function<? super T, ? extends Monad<U, LensLike<S, ?, A, B, Lens>>> f) {
        return Lens.lens(View.view(this), (s, b) -> Set.set((LensLike)((Monad)f.apply((T)Set.set(this, b, s))).coerce(), b, s));
    }

    default public <R> Lens<R, T, A, B> diMapL(Function<? super R, ? extends S> fn) {
        return (Lens)LensLike.super.diMapL((Function)fn).coerce();
    }

    default public <U> Lens<S, U, A, B> diMapR(Function<? super T, ? extends U> fn) {
        return (Lens)LensLike.super.diMapR((Function)fn).coerce();
    }

    default public <R, U> Lens<R, U, A, B> diMap(Function<? super R, ? extends S> lFn, Function<? super T, ? extends U> rFn) {
        return (Lens)LensLike.super.diMap((Function)lFn, (Function)rFn).coerce();
    }

    default public <R> Lens<R, T, A, B> contraMap(Function<? super R, ? extends S> fn) {
        return (Lens)LensLike.super.contraMap((Function)fn).coerce();
    }

    default public <R> Lens<R, T, A, B> mapS(Function<? super R, ? extends S> fn) {
        return Lens.lens(View.view(this).compose(fn), (r, b) -> Set.set(this, b, fn.apply((Object)r)));
    }

    default public <U> Lens<S, U, A, B> mapT(Function<? super T, ? extends U> fn) {
        return this.fmap((Function)fn);
    }

    default public <C> Lens<S, T, C, B> mapA(Function<? super A, ? extends C> fn) {
        return this.andThen(Lens.lens(fn, (a, b) -> b));
    }

    default public <Z> Lens<S, T, A, Z> mapB(Function<? super Z, ? extends B> fn) {
        return Lens.lens(View.view(this), (s, z) -> Set.set(this, fn.apply((Object)z), s));
    }

    default public <C, D> Lens<S, T, C, D> andThen(Lens<A, B, C, D> f) {
        return f.compose(this);
    }

    default public <Q, R> Lens<Q, R, A, B> compose(Lens<Q, R, S, T> g) {
        return Lens.lens(View.view(g).fmap((Function)View.view(this)), (q, b) -> Over.over(g, Set.set(this, b), q));
    }

    public static <S, T, A, B> Lens<S, T, A, B> lens(final Function<? super S, ? extends A> getter, final BiFunction<? super S, ? super B, ? extends T> setter) {
        return new Lens<S, T, A, B>(){

            @Override
            public <F extends Functor, FT extends Functor<T, F>, FB extends Functor<B, F>> FT apply(Function<? super A, ? extends FB> fn, S s) {
                return (FT)((Functor)fn.apply(getter.apply(s))).fmap((? super A b) -> setter.apply(s, b));
            }
        };
    }

    public static <S, A> Simple<S, A> simpleLens(Function<? super S, ? extends A> getter, BiFunction<? super S, ? super A, ? extends S> setter) {
        return Simple.adapt(Lens.lens(getter, setter));
    }

    public static <S, A, B, C, D> Lens<S, S, Tuple2<A, B>, Tuple2<C, D>> both(Lens<S, S, A, C> f, Lens<S, S, B, D> g) {
        return Lens.lens(Both.both(View.view(f), View.view(g)), (s, cd) -> ((Tuple2)cd.biMap((Function)Set.set(f), (Function)Set.set(g))).into(Fn1::compose).apply(s));
    }

    public static <S, A, B> Simple<S, Tuple2<A, B>> both(Simple<S, A> f, Simple<S, B> g) {
        return Simple.adapt(Lens.both(f, g));
    }

    @FunctionalInterface
    public static interface Simple<S, A>
    extends Lens<S, S, A, A>,
    LensLike.Simple<S, A, Lens> {
        default public <R> Simple<R, A> compose(Simple<R, S> g) {
            return Simple.adapt(Lens.super.compose(g));
        }

        default public <B> Simple<S, B> andThen(Simple<A, B> f) {
            return f.compose(this);
        }

        public static <S, A> Simple<S, A> adapt(Lens<S, S, A, A> lens) {
            return lens::apply;
        }

        public static <S, A, B> Simple<S, Tuple2<A, B>> both(Lens<S, S, A, A> f, Lens<S, S, B, B> g) {
            return Simple.adapt(Lens.both(f, g));
        }
    }
}

