/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.lens.Lens;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class CollectionLens {
    private CollectionLens() {
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, CX> asCopy(Function<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(copyFn, (__, copy) -> copy);
    }

    @Deprecated
    public static <X, CX extends Collection<X>> Lens.Simple<CX, Set<X>> asSet() {
        return Lens.simpleLens(HashSet::new, (xsL, xsS) -> {
            xsL.retainAll((Collection<?>)xsS);
            return xsL;
        });
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Set<X>> asSet(Function<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(HashSet::new, (xsL, xsS) -> {
            HashSet missing = new HashSet(xsS);
            missing.removeAll((Collection<?>)xsL);
            Collection updated = (Collection)copyFn.apply((Object)xsL);
            updated.addAll(missing);
            updated.retainAll((Collection<?>)xsS);
            return updated;
        });
    }

    @Deprecated
    public static <X, CX extends Collection<X>> Lens.Simple<CX, Stream<X>> asStream() {
        return Lens.simpleLens(Collection::stream, (xsL, xsS) -> {
            xsL.clear();
            xsS.forEach(xsL::add);
            return xsL;
        });
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Stream<X>> asStream(Function<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(Collection::stream, (xsL, xsS) -> {
            Collection updated = (Collection)copyFn.apply((Object)xsL);
            updated.clear();
            xsS.forEach(updated::add);
            return updated;
        });
    }
}

