/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.lens.lenses;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.builtin.fn2.Eq;
import com.jnape.palatable.lambda.functions.builtin.fn2.Filter;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn2.ToCollection;
import com.jnape.palatable.lambda.functions.builtin.fn2.ToMap;
import com.jnape.palatable.lambda.lens.Iso;
import com.jnape.palatable.lambda.lens.Lens;
import com.jnape.palatable.lambda.lens.functions.View;
import com.jnape.palatable.lambda.lens.lenses.MaybeLens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class MapLens {
    private MapLens() {
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, java.util.Map<K, V>> asCopy() {
        return Lens.simpleLens(HashMap::new, (__, copy) -> copy);
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, Maybe<V>> valueAt(K k) {
        return Lens.simpleLens(m -> Maybe.maybe(m.get(k)), (m, maybeV) -> {
            HashMap updated = new HashMap(m);
            return ((Maybe)maybeV.fmap(v -> {
                updated.put(k, v);
                return updated;
            })).orElseGet(() -> {
                updated.remove(k);
                return updated;
            });
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, V> valueAt(K k, V defaultValue) {
        return Lens.Simple.adapt(MaybeLens.unLiftB(MaybeLens.unLiftA(MapLens.valueAt(k), defaultValue)));
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, Set<K>> keys() {
        return Lens.simpleLens(m -> new HashSet(m.keySet()), (m, ks) -> {
            HashSet ksCopy = new HashSet(ks);
            HashMap updated = new HashMap(m);
            Set keys = updated.keySet();
            keys.retainAll(ksCopy);
            ksCopy.removeAll(keys);
            ksCopy.forEach(k -> updated.put(k, null));
            return updated;
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, Collection<V>> values() {
        return Lens.simpleLens(m -> new ArrayList(m.values()), (m, vs) -> {
            HashMap updated = new HashMap(m);
            HashSet valueSet = new HashSet(vs);
            Set matchingKeys = (Set)Filter.filter(kv -> valueSet.contains(kv.getValue())).andThen(Map.map(Map.Entry::getKey)).andThen((Function)ToCollection.toCollection(HashSet::new)).apply(updated.entrySet());
            updated.keySet().retainAll(matchingKeys);
            return updated;
        });
    }

    public static <K, V> Lens.Simple<java.util.Map<K, V>, java.util.Map<V, K>> inverted() {
        return Lens.simpleLens(m -> {
            HashMap inverted = new HashMap();
            m.forEach((key, value) -> inverted.put(value, key));
            return inverted;
        }, (m, im) -> {
            HashMap updated = new HashMap(m);
            updated.clear();
            updated.putAll((java.util.Map)View.view(MapLens.inverted(), im));
            return updated;
        });
    }

    @Deprecated
    public static <K, V, V2> Lens.Simple<java.util.Map<K, V>, java.util.Map<K, V2>> mappingValues(Function<? super V, ? extends V2> fn) {
        return Lens.simpleLens(m -> ToMap.toMap(HashMap::new, Map.map(t -> t.biMapR(fn), Map.map(Tuple2::fromEntry, m.entrySet()))), (s, b) -> {
            Set retainKeys = (Set)Filter.filter(kv -> Eq.eq(fn.apply((Object)kv.getValue()), b.get(kv.getKey()))).andThen(Map.map(Map.Entry::getKey)).andThen((Function)ToCollection.toCollection(HashSet::new)).apply(s.entrySet());
            HashMap copy = new HashMap(s);
            copy.keySet().retainAll(retainKeys);
            return copy;
        });
    }

    public static <K, V, V2> Lens.Simple<java.util.Map<K, V>, java.util.Map<K, V2>> mappingValues(Iso<V, V, V2, V2> iso) {
        return Lens.simpleLens(m -> ToMap.toMap(HashMap::new, Map.map(t -> t.biMapR((Function)View.view(iso)), Map.map(Tuple2::fromEntry, m.entrySet()))), (s, b) -> (java.util.Map)View.view(MapLens.mappingValues(iso.mirror()), b));
    }
}

