/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.monoid;

import com.jnape.palatable.lambda.functions.builtin.fn2.Cons;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn2.ReduceLeft;
import com.jnape.palatable.lambda.functions.builtin.fn2.ReduceRight;
import com.jnape.palatable.lambda.functions.builtin.fn2.Snoc;
import com.jnape.palatable.lambda.semigroup.Semigroup;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Monoid<A>
extends Semigroup<A> {
    public A identity();

    default public A reduceLeft(Iterable<A> as) {
        return ReduceLeft.reduceLeft(this.toBiFunction(), as).orElse(this.identity());
    }

    default public A reduceRight(Iterable<A> as) {
        return ReduceRight.reduceRight(this.toBiFunction(), as).orElse(this.identity());
    }

    default public <B> A foldMap(Function<? super B, ? extends A> fn, Iterable<B> bs) {
        return this.reduceLeft(Map.map(fn, bs));
    }

    @Override
    default public A foldLeft(A a, Iterable<A> as) {
        return this.reduceLeft(Cons.cons(a, as));
    }

    @Override
    default public A foldRight(A a, Iterable<A> as) {
        return this.reduceRight(Snoc.snoc(a, as));
    }

    @Override
    default public Monoid<A> flip() {
        return Monoid.monoid(Semigroup.super.flip(), this.identity());
    }

    public static <A> Monoid<A> monoid(final Semigroup<A> semigroup, final A identity) {
        return new Monoid<A>(){

            @Override
            public A identity() {
                return identity;
            }

            @Override
            public A apply(A x, A y) {
                return semigroup.apply(x, y);
            }
        };
    }

    public static <A> Monoid<A> monoid(final Semigroup<A> semigroup, final Supplier<A> identitySupplier) {
        return new Monoid<A>(){

            @Override
            public A identity() {
                return identitySupplier.get();
            }

            @Override
            public A apply(A x, A y) {
                return semigroup.apply(x, y);
            }
        };
    }
}

