/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.traversable;

import com.jnape.palatable.lambda.functions.builtin.fn1.Flatten;
import com.jnape.palatable.lambda.functions.builtin.fn2.CartesianProduct;
import com.jnape.palatable.lambda.functions.builtin.fn2.Cons;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldRight;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;

public final class LambdaIterable<A>
implements Monad<A, LambdaIterable>,
Traversable<A, LambdaIterable> {
    private final Iterable<A> as;

    private LambdaIterable(Iterable<? extends A> as) {
        this.as = as;
    }

    public Iterable<A> unwrap() {
        return this.as;
    }

    public <B> LambdaIterable<B> fmap(Function<? super A, ? extends B> fn) {
        return LambdaIterable.wrap(Map.map(fn, this.as));
    }

    public <B> LambdaIterable<B> pure(B b) {
        return LambdaIterable.wrap(Collections.singleton(b));
    }

    public <B> LambdaIterable<B> zip(Applicative<Function<? super A, ? extends B>, LambdaIterable> appFn) {
        return LambdaIterable.wrap(Map.map(Into.into((f, x) -> f.apply(x)), CartesianProduct.cartesianProduct(((LambdaIterable)appFn.coerce()).unwrap(), this.as)));
    }

    public <B> LambdaIterable<B> discardL(Applicative<B, LambdaIterable> appB) {
        return (LambdaIterable)Monad.super.discardL(appB).coerce();
    }

    public <B> LambdaIterable<A> discardR(Applicative<B, LambdaIterable> appB) {
        return (LambdaIterable)Monad.super.discardR(appB).coerce();
    }

    public <B> LambdaIterable<B> flatMap(Function<? super A, ? extends Monad<B, LambdaIterable>> f) {
        return LambdaIterable.wrap(Flatten.flatten(Map.map(a -> ((LambdaIterable)((Monad)f.apply((Object)a)).coerce()).unwrap(), this.as)));
    }

    @Override
    public <B, App extends Applicative, TravB extends Traversable<B, LambdaIterable>, AppB extends Applicative<B, App>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Function<? super A, ? extends AppB> fn, Function<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)FoldRight.foldRight((a, appTrav) -> appTrav.zip(((Applicative)fn.apply((Object)a)).fmap((T b) -> bs -> LambdaIterable.wrap(Cons.cons(b, ((LambdaIterable)bs).unwrap())))), (Applicative)pure.apply(LambdaIterable.empty()), this.as);
    }

    public boolean equals(Object other) {
        if (other instanceof LambdaIterable) {
            Iterator<A> xs = this.as.iterator();
            Iterator<A> ys = ((LambdaIterable)other).as.iterator();
            while (xs.hasNext() && ys.hasNext()) {
                if (Objects.equals(xs.next(), ys.next())) continue;
                return false;
            }
            return xs.hasNext() == ys.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.as);
    }

    public static <A> LambdaIterable<A> wrap(Iterable<? extends A> as) {
        return new LambdaIterable<A>(as);
    }

    public static <A> LambdaIterable<A> empty() {
        return LambdaIterable.wrap(Collections.emptyList());
    }
}

