/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.Try;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.choice.Choice3;
import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek2;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functions.specialized.SideEffect;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Bifunctor;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.io.IO;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Arrays;
import java.util.Objects;

public abstract class Either<L, R>
implements CoProduct2<L, R, Either<L, R>>,
Monad<R, Either<L, ?>>,
Traversable<R, Either<L, ?>>,
Bifunctor<L, R, Either<?, ?>> {
    private Either() {
    }

    public final R or(R defaultValue) {
        return (R)this.recover(l -> defaultValue);
    }

    public final R recover(Fn1<? super L, ? extends R> recoveryFn) {
        return this.match((Fn1)recoveryFn, Id.id());
    }

    public final L forfeit(Fn1<? super R, ? extends L> forfeitFn) {
        return this.match(Id.id(), (Fn1)forfeitFn);
    }

    public final <T extends Throwable> R orThrow(Fn1<? super L, ? extends T> throwableFn) throws T {
        return (R)this.match((Fn1)l -> {
            throw (Throwable)throwableFn.apply((Object)l);
        }, Id.id());
    }

    public final Either<L, R> filter(Fn1<? super R, ? extends Boolean> pred, Fn0<L> leftFn0) {
        return this.filter(pred, (? super R __) -> leftFn0.apply());
    }

    public final Either<L, R> filter(Fn1<? super R, ? extends Boolean> pred, Fn1<? super R, ? extends L> leftFn) {
        return this.flatMap((A r) -> (Boolean)pred.apply((Object)r) != false ? Either.right(r) : Either.left(leftFn.apply((Object)r)));
    }

    @Override
    public <R2> Either<L, R2> flatMap(Fn1<? super R, ? extends Monad<R2, Either<L, ?>>> rightFn) {
        return this.match((Fn1)Either::left, (Fn1)rightFn.fmap(Functor::coerce));
    }

    public final Either<R, L> invert() {
        return this.match((Fn1)Either::right, (Fn1)Either::left);
    }

    @SafeVarargs
    public final Either<L, R> merge(Fn2<? super L, ? super L, ? extends L> leftFn, Fn2<? super R, ? super R, ? extends R> rightFn, Either<L, R> ... others) {
        return FoldLeft.foldLeft((x, y) -> x.match((Fn1)l1 -> y.match((Fn1)l2 -> Either.left(leftFn.apply((Object)l1, (Object)l2)), (Fn1)r -> Either.left(l1)), (Fn1)r1 -> y.match((Fn1)Either::left, (Fn1)r2 -> Either.right(rightFn.apply((Object)r1, (Object)r2)))), this, Arrays.asList(others));
    }

    public Either<L, R> peek(Fn1<? super R, ? extends IO<?>> effect) {
        return Peek.peek(effect, this);
    }

    public Either<L, R> peek(Fn1<? super L, ? extends IO<?>> leftEffect, Fn1<? super R, ? extends IO<?>> rightEffect) {
        return Peek2.peek2(leftEffect, rightEffect, this);
    }

    @Override
    public abstract <V> V match(Fn1<? super L, ? extends V> var1, Fn1<? super R, ? extends V> var2);

    public <C> Choice3<L, R, C> diverge() {
        return this.match((Fn1)Choice3::a, (Fn1)Choice3::b);
    }

    @Override
    public final <R2> Either<L, R2> fmap(Fn1<? super R, ? extends R2> fn) {
        return (Either)Monad.super.fmap(fn).coerce();
    }

    public final <L2> Either<L2, R> biMapL(Fn1<? super L, ? extends L2> fn) {
        return (Either)Bifunctor.super.biMapL(fn);
    }

    public final <R2> Either<L, R2> biMapR(Fn1<? super R, ? extends R2> fn) {
        return (Either)Bifunctor.super.biMapR(fn);
    }

    public final <L2, R2> Either<L2, R2> biMap(Fn1<? super L, ? extends L2> leftFn, Fn1<? super R, ? extends R2> rightFn) {
        return this.match((Fn1)l -> Either.left(leftFn.apply((Object)l)), (Fn1)r -> Either.right(rightFn.apply((Object)r)));
    }

    @Override
    public final <R2> Either<L, R2> pure(R2 r2) {
        return Either.right(r2);
    }

    @Override
    public final <R2> Either<L, R2> zip(Applicative<Fn1<? super R, ? extends R2>, Either<L, ?>> appFn) {
        return (Either)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <R2> Lazy<Either<L, R2>> lazyZip(Lazy<? extends Applicative<Fn1<? super R, ? extends R2>, Either<L, ?>>> lazyAppFn) {
        return this.match((Fn1)l -> Lazy.lazy(Either.left(l)), (Fn1)r -> lazyAppFn.fmap((A eitherLF) -> (Either)eitherLF.fmap((A f) -> f.apply(r)).coerce()));
    }

    @Override
    public final <R2> Either<L, R2> discardL(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Monad.super.discardL(appB).coerce();
    }

    @Override
    public final <R2> Either<L, R> discardR(Applicative<R2, Either<L, ?>> appB) {
        return (Either)Monad.super.discardR(appB).coerce();
    }

    @Override
    public final <R2, App extends Applicative<?, App>, TravB extends Traversable<R2, Either<L, ?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super R, ? extends Applicative<R2, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match((Fn1)l -> (Applicative)pure.apply((Object)Either.left(l)), (Fn1)r -> ((Applicative)fn.apply((Object)r)).fmap(Either::right));
    }

    public final Maybe<R> toMaybe() {
        return this.projectB();
    }

    public static <L, R> Either<L, R> fromMaybe(Maybe<R> maybe, Fn0<L> leftFn0) {
        return ((Maybe)maybe.fmap(Either::right)).orElseGet(() -> Either.left(leftFn0.apply()));
    }

    public static <L, R> Either<L, R> trying(Fn0<? extends R> fn0, Fn1<? super Throwable, ? extends L> leftFn) {
        return Try.trying(fn0).toEither(leftFn);
    }

    public static <R> Either<Throwable, R> trying(Fn0<? extends R> fn0) {
        return Either.trying(fn0, Id.id());
    }

    public static <L> Either<L, Unit> trying(SideEffect sideEffect, Fn1<? super Throwable, ? extends L> leftFn) {
        return Try.trying(sideEffect).toEither(leftFn);
    }

    public static Either<Throwable, Unit> trying(SideEffect sideEffect) {
        return Either.trying(sideEffect, Id.id());
    }

    public static <L, R> Either<L, R> left(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> right(R r) {
        return new Right(r);
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R r;

        private Right(R r) {
            this.r = r;
        }

        @Override
        public <V> V match(Fn1<? super L, ? extends V> leftFn, Fn1<? super R, ? extends V> rightFn) {
            return rightFn.apply(this.r);
        }

        public boolean equals(Object other) {
            return other instanceof Right && Objects.equals(this.r, ((Right)other).r);
        }

        public int hashCode() {
            return Objects.hash(this.r);
        }

        public String toString() {
            return "Right{r=" + this.r + '}';
        }
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L l;

        private Left(L l) {
            this.l = l;
        }

        @Override
        public <V> V match(Fn1<? super L, ? extends V> leftFn, Fn1<? super R, ? extends V> rightFn) {
            return leftFn.apply(this.l);
        }

        public boolean equals(Object other) {
            return other instanceof Left && Objects.equals(this.l, ((Left)other).l);
        }

        public int hashCode() {
            return Objects.hash(this.l);
        }

        public String toString() {
            return "Left{l=" + this.l + '}';
        }
    }
}

