/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.choice.Choice2;
import com.jnape.palatable.lambda.adt.choice.Choice3;
import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn2.Peek;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.io.IO;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Objects;
import java.util.Optional;

public abstract class Maybe<A>
implements CoProduct2<Unit, A, Maybe<A>>,
Monad<A, Maybe<?>>,
Traversable<A, Maybe<?>> {
    private Maybe() {
    }

    public final A orElseGet(Fn0<A> otherFn0) {
        return (A)this.match(__ -> otherFn0.apply(), Id.id());
    }

    public final A orElse(A other) {
        return (A)this.orElseGet(() -> other);
    }

    public final <E extends Throwable> A orElseThrow(Fn0<? extends E> throwableSupplier) throws E {
        return (A)this.orElseGet(Fn0.fn0(() -> {
            throw (Throwable)throwableSupplier.apply();
        }));
    }

    public final Maybe<A> filter(Fn1<? super A, ? extends Boolean> predicate) {
        return this.flatMap((A a) -> (Boolean)predicate.apply(a) != false ? Maybe.just(a) : Maybe.nothing());
    }

    public final <L> Either<L, A> toEither(Fn0<L> lFn0) {
        return ((Maybe)this.fmap(Either::right)).orElseGet(() -> Either.left(lFn0.apply()));
    }

    public final Optional<A> toOptional() {
        return ((Maybe)this.fmap(Optional::of)).orElseGet(Optional::empty);
    }

    public final <B> Maybe<B> pure(B b) {
        return Maybe.just(b);
    }

    public final <B> Maybe<B> fmap(Fn1<? super A, ? extends B> fn) {
        return (Maybe)Monad.super.fmap((Fn1)fn).coerce();
    }

    public final <B> Maybe<B> zip(Applicative<Fn1<? super A, ? extends B>, Maybe<?>> appFn) {
        return (Maybe)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <B> Lazy<Maybe<B>> lazyZip(Lazy<? extends Applicative<Fn1<? super A, ? extends B>, Maybe<?>>> lazyAppFn) {
        return this.match(Constantly.constantly(Lazy.lazy(Maybe.nothing())), a -> lazyAppFn.fmap((A maybeF) -> (Maybe)maybeF.fmap((A f) -> f.apply(a)).coerce()));
    }

    public final <B> Maybe<B> discardL(Applicative<B, Maybe<?>> appB) {
        return (Maybe)Monad.super.discardL(appB).coerce();
    }

    public final <B> Maybe<A> discardR(Applicative<B, Maybe<?>> appB) {
        return (Maybe)Monad.super.discardR(appB).coerce();
    }

    public final <B> Maybe<B> flatMap(Fn1<? super A, ? extends Monad<B, Maybe<?>>> f) {
        return this.match(Constantly.constantly(Maybe.nothing()), f.fmap(Functor::coerce));
    }

    public <B> Choice3<Unit, A, B> diverge() {
        return this.match(Choice3::a, Choice3::b);
    }

    @Override
    public Tuple2<Maybe<Unit>, Maybe<A>> project() {
        return CoProduct2.super.project().into(HList::tuple);
    }

    public Choice2<A, Unit> invert() {
        return this.match(Choice2::b, Choice2::a);
    }

    public final Maybe<A> peek(Fn1<? super A, ? extends IO<?>> effect) {
        return Peek.peek(effect, this);
    }

    @Override
    public final <B, App extends Applicative<?, App>, TravB extends Traversable<B, Maybe<?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super A, ? extends Applicative<B, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match(__ -> (Applicative)pure.apply((Object)Maybe.nothing()), a -> ((Applicative)fn.apply(a)).fmap(Maybe::just));
    }

    public static <A> Maybe<A> fromEither(Either<?, A> either) {
        return either.toMaybe();
    }

    public static <A> Maybe<A> fromOptional(Optional<? extends A> optional) {
        return optional.map(Maybe::just).orElse(Maybe.nothing());
    }

    public static <A> Maybe<A> maybe(A a) {
        return a == null ? Maybe.nothing() : Maybe.just(a);
    }

    public static <A> Maybe<A> just(A a) {
        if (a == null) {
            throw new NullPointerException();
        }
        return new Just(a);
    }

    public static <A> Maybe<A> nothing() {
        return Nothing.INSTANCE;
    }

    private static final class Just<A>
    extends Maybe<A> {
        private final A a;

        private Just(A a) {
            this.a = a;
        }

        @Override
        public <R> R match(Fn1<? super Unit, ? extends R> aFn, Fn1<? super A, ? extends R> bFn) {
            return bFn.apply(this.a);
        }

        public boolean equals(Object other) {
            return other instanceof Just && Objects.equals(this.a, ((Just)other).a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return "Just " + this.a;
        }
    }

    private static final class Nothing<A>
    extends Maybe<A> {
        private static final Nothing<?> INSTANCE = new Nothing();

        private Nothing() {
        }

        @Override
        public <R> R match(Fn1<? super Unit, ? extends R> aFn, Fn1<? super A, ? extends R> bFn) {
            return aFn.apply(Unit.UNIT);
        }

        public String toString() {
            return "Nothing";
        }
    }
}

