/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt;

import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn1.Upcast;
import com.jnape.palatable.lambda.functions.specialized.SideEffect;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.internal.Runtime;
import com.jnape.palatable.lambda.io.IO;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Objects;

public abstract class Try<A>
implements Monad<A, Try<?>>,
Traversable<A, Try<?>>,
CoProduct2<Throwable, A, Try<A>> {
    private Try() {
    }

    public final <S extends Throwable> Try<A> catching(Class<S> throwableType, Fn1<? super S, ? extends A> recoveryFn) {
        return this.catching(throwableType::isInstance, (? super Throwable t) -> recoveryFn.apply((Object)t));
    }

    public final Try<A> catching(Fn1<? super Throwable, ? extends Boolean> predicate, Fn1<? super Throwable, ? extends A> recoveryFn) {
        return this.match(t -> (Boolean)predicate.apply((Throwable)t) != false ? Try.success(recoveryFn.apply((Throwable)t)) : Try.failure(t), Try::success);
    }

    public final Try<A> ensuring(SideEffect sideEffect) {
        return this.match(t -> ((Try)Try.trying(sideEffect).fmap(Constantly.constantly(Try.failure(t)))).recover(t2 -> {
            t.addSuppressed((Throwable)t2);
            return Try.failure(t);
        }), a -> Try.trying(sideEffect).fmap(Constantly.constantly(a)));
    }

    public final A recover(Fn1<? super Throwable, ? extends A> fn) {
        return this.match(fn, Id.id());
    }

    public final Throwable forfeit(Fn1<? super A, ? extends Throwable> fn) {
        return this.match(Id.id(), fn);
    }

    public final <T extends Throwable> A orThrow() throws T {
        try {
            return this.orThrow(Id.id());
        }
        catch (Throwable t) {
            throw Runtime.throwChecked(t);
        }
    }

    public abstract <T extends Throwable> A orThrow(Fn1<? super Throwable, ? extends T> var1) throws T;

    public final Maybe<A> toMaybe() {
        return this.match(__ -> Maybe.nothing(), Maybe::just);
    }

    public final Either<Throwable, A> toEither() {
        return this.toEither(Id.id());
    }

    public final <L> Either<L, A> toEither(Fn1<? super Throwable, ? extends L> fn) {
        return this.match(fn.fmap(Either::left), Either::right);
    }

    public <B> Try<B> fmap(Fn1<? super A, ? extends B> fn) {
        return (Try)Monad.super.fmap((Fn1)fn).coerce();
    }

    public <B> Try<B> flatMap(Fn1<? super A, ? extends Monad<B, Try<?>>> f) {
        return this.match(Try::failure, a -> (Try)((Monad)f.apply(a)).coerce());
    }

    public <B> Try<B> pure(B b) {
        return Try.success(b);
    }

    public <B> Try<B> zip(Applicative<Fn1<? super A, ? extends B>, Try<?>> appFn) {
        return (Try)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <B> Lazy<Try<B>> lazyZip(Lazy<? extends Applicative<Fn1<? super A, ? extends B>, Try<?>>> lazyAppFn) {
        return this.match(f -> Lazy.lazy(Try.failure(f)), s -> lazyAppFn.fmap((A tryF) -> (Try)tryF.fmap((A f) -> f.apply(s)).coerce()));
    }

    public <B> Try<B> discardL(Applicative<B, Try<?>> appB) {
        return (Try)Monad.super.discardL(appB).coerce();
    }

    public <B> Try<A> discardR(Applicative<B, Try<?>> appB) {
        return (Try)Monad.super.discardR(appB).coerce();
    }

    @Override
    public <B, App extends Applicative<?, App>, TravB extends Traversable<B, Try<?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super A, ? extends Applicative<B, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match(t -> (Applicative)pure.apply((Object)Try.failure(t)), a -> (Applicative)((Applicative)fn.apply(a)).fmap(Try::success).fmap(Functor::coerce).coerce());
    }

    public static <A> Try<A> success(A a) {
        return new Success(a);
    }

    public static <A> Try<A> failure(Throwable t) {
        return new Failure(t);
    }

    public static <A> Try<A> trying(Fn0<? extends A> supplier) {
        try {
            return Try.success(supplier.apply());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }

    public static Try<Unit> trying(SideEffect sideEffect) {
        return Try.trying(() -> {
            IO.io(sideEffect).unsafePerformIO();
            return Unit.UNIT;
        });
    }

    public static <A extends AutoCloseable, B> Try<B> withResources(Fn0<? extends A> fn0, Fn1<? super A, ? extends Try<? extends B>> fn) {
        return Try.trying(() -> {
            try (AutoCloseable resource = (AutoCloseable)fn0.apply();){
                Monad monad = ((Try)fn.apply(resource)).fmap((Fn1)Upcast.upcast());
                return monad;
            }
        }).flatMap((Fn1)Id.id());
    }

    public static <A extends AutoCloseable, B extends AutoCloseable, C> Try<C> withResources(Fn0<? extends A> fn0, Fn1<? super A, ? extends B> bFn, Fn1<? super B, ? extends Try<? extends C>> fn) {
        return Try.withResources(fn0, a -> Try.withResources(() -> (AutoCloseable)bFn.apply(a), fn::apply));
    }

    public static <A extends AutoCloseable, B extends AutoCloseable, C extends AutoCloseable, D> Try<D> withResources(Fn0<? extends A> fn0, Fn1<? super A, ? extends B> bFn, Fn1<? super B, ? extends C> cFn, Fn1<? super C, ? extends Try<? extends D>> fn) {
        return Try.withResources(fn0, bFn, b -> Try.withResources(() -> (AutoCloseable)cFn.apply((Object)b), fn::apply));
    }

    private static final class Success<A>
    extends Try<A> {
        private final A a;

        private Success(A a) {
            this.a = a;
        }

        @Override
        public <T extends Throwable> A orThrow(Fn1<? super Throwable, ? extends T> fn) {
            return this.a;
        }

        @Override
        public <R> R match(Fn1<? super Throwable, ? extends R> aFn, Fn1<? super A, ? extends R> bFn) {
            return bFn.apply(this.a);
        }

        public boolean equals(Object other) {
            return other instanceof Success && Objects.equals(this.a, ((Success)other).a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return "Success{a=" + this.a + '}';
        }
    }

    private static final class Failure<A>
    extends Try<A> {
        private final Throwable t;

        private Failure(Throwable t) {
            this.t = t;
        }

        @Override
        public <T extends Throwable> A orThrow(Fn1<? super Throwable, ? extends T> fn) throws T {
            throw (Throwable)fn.apply(this.t);
        }

        @Override
        public <R> R match(Fn1<? super Throwable, ? extends R> aFn, Fn1<? super A, ? extends R> bFn) {
            return aFn.apply(this.t);
        }

        public boolean equals(Object other) {
            return other instanceof Failure && Objects.equals(this.t, ((Failure)other).t);
        }

        public int hashCode() {
            return Objects.hash(this.t);
        }

        public String toString() {
            return "Failure{t=" + this.t + '}';
        }
    }
}

