/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.adt.hmap;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.adt.hmap.TypeSafeKey;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.optics.functions.View;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public final class HMap
implements Iterable<Tuple2<TypeSafeKey<?, ?>, Object>> {
    private static final HMap EMPTY = new HMap(Collections.emptyMap());
    private final java.util.Map<TypeSafeKey<?, ?>, Object> table;

    private HMap(java.util.Map<TypeSafeKey<?, ?>, Object> table) {
        this.table = table;
    }

    public <A, B> Maybe<B> get(TypeSafeKey<A, B> key) {
        return Maybe.maybe(this.table.get(key)).fmap(View.view(key));
    }

    public <V> V demand(TypeSafeKey<?, V> key) throws NoSuchElementException {
        return this.get(key).orElseThrow(() -> new NoSuchElementException("Demanded value for key " + key + ", but couldn't find one."));
    }

    public <V> HMap put(TypeSafeKey<?, V> key, V value) {
        return this.alter(t -> t.put(key, View.view(key.mirror(), value)));
    }

    public HMap putAll(HMap hMap) {
        return this.alter(t -> t.putAll(hMap.table));
    }

    public boolean containsKey(TypeSafeKey<?, ?> key) {
        return this.table.containsKey(key);
    }

    public HMap remove(TypeSafeKey<?, ?> key) {
        return this.alter(t -> t.remove(key));
    }

    public HMap removeAll(HMap hMap) {
        return this.alter(t -> t.keySet().removeAll(hMap.table.keySet()));
    }

    public Set<TypeSafeKey<?, ?>> keys() {
        return new HashSet(this.table.keySet());
    }

    public Collection<Object> values() {
        return new ArrayList<Object>(this.table.values());
    }

    public java.util.Map<TypeSafeKey<?, ?>, Object> toMap() {
        return new HashMap(this.table);
    }

    @Override
    public Iterator<Tuple2<TypeSafeKey<?, ?>, Object>> iterator() {
        return Map.map(Tuple2::fromEntry, this.table.entrySet()).iterator();
    }

    public boolean equals(Object other) {
        if (other instanceof HMap) {
            HMap that = (HMap)other;
            return Objects.equals(this.table, that.table);
        }
        return false;
    }

    public int hashCode() {
        return 31 * Objects.hashCode(this.table);
    }

    public String toString() {
        return "HMap{table=" + this.table + '}';
    }

    private HMap alter(Consumer<java.util.Map<TypeSafeKey<?, ?>, Object>> alterFn) {
        HashMap copy = new HashMap(this.table);
        alterFn.accept(copy);
        return new HMap(copy);
    }

    public static HMap emptyHMap() {
        return EMPTY;
    }

    public static <V> HMap singletonHMap(TypeSafeKey<?, V> key, V value) {
        return HMap.emptyHMap().put(key, value);
    }

    public static <V1, V2> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2) {
        return HMap.singletonHMap(key1, value1).put(key2, value2);
    }

    public static <V1, V2, V3> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3) {
        return HMap.hMap(key1, value1, key2, value2).put(key3, value3);
    }

    public static <V1, V2, V3, V4> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3, TypeSafeKey<?, V4> key4, V4 value4) {
        return HMap.hMap(key1, value1, key2, value2, key3, value3).put(key4, value4);
    }

    public static <V1, V2, V3, V4, V5> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3, TypeSafeKey<?, V4> key4, V4 value4, TypeSafeKey<?, V5> key5, V5 value5) {
        return HMap.hMap(key1, value1, key2, value2, key3, value3, key4, value4).put(key5, value5);
    }

    public static <V1, V2, V3, V4, V5, V6> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3, TypeSafeKey<?, V4> key4, V4 value4, TypeSafeKey<?, V5> key5, V5 value5, TypeSafeKey<?, V6> key6, V6 value6) {
        return HMap.hMap(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5).put(key6, value6);
    }

    public static <V1, V2, V3, V4, V5, V6, V7> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3, TypeSafeKey<?, V4> key4, V4 value4, TypeSafeKey<?, V5> key5, V5 value5, TypeSafeKey<?, V6> key6, V6 value6, TypeSafeKey<?, V7> key7, V7 value7) {
        return HMap.hMap(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6).put(key7, value7);
    }

    public static <V1, V2, V3, V4, V5, V6, V7, V8> HMap hMap(TypeSafeKey<?, V1> key1, V1 value1, TypeSafeKey<?, V2> key2, V2 value2, TypeSafeKey<?, V3> key3, V3 value3, TypeSafeKey<?, V4> key4, V4 value4, TypeSafeKey<?, V5> key5, V5 value5, TypeSafeKey<?, V6> key6, V6 value6, TypeSafeKey<?, V7> key7, V7 value7, TypeSafeKey<?, V8> key8, V8 value8) {
        return HMap.hMap(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7).put(key8, value8);
    }
}

