/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.builtin.fn2;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn1.Distinct;
import com.jnape.palatable.lambda.functions.builtin.fn1.Empty;
import com.jnape.palatable.lambda.functions.builtin.fn2.Filter;
import com.jnape.palatable.lambda.functions.builtin.fn2.ToCollection;
import java.util.HashSet;

public final class Difference<A>
implements Fn2<Iterable<A>, Iterable<A>, Iterable<A>> {
    private static final Difference<?> INSTANCE = new Difference();

    private Difference() {
    }

    @Override
    public Iterable<A> checkedApply(Iterable<A> xs, Iterable<A> ys) {
        return () -> {
            if (Empty.empty(xs).booleanValue()) {
                return xs.iterator();
            }
            if (Empty.empty(ys).booleanValue()) {
                return Distinct.distinct(xs).iterator();
            }
            HashSet uniqueYs = ToCollection.toCollection(HashSet::new, ys);
            return Distinct.distinct(Filter.filter(a -> !uniqueYs.contains(a), xs)).iterator();
        };
    }

    public static <A> Difference<A> difference() {
        return INSTANCE;
    }

    public static <A> Fn1<Iterable<A>, Iterable<A>> difference(Iterable<A> xs) {
        return Difference.difference().apply(xs);
    }

    public static <A> Iterable<A> difference(Iterable<A> xs, Iterable<A> ys) {
        return Difference.difference(xs).apply(ys);
    }
}

