/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.builtin.fn4;

import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.Fn3;
import com.jnape.palatable.lambda.functions.Fn4;
import com.jnape.palatable.lambda.internal.iteration.RateLimitingIterable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;

public final class RateLimit<A>
implements Fn4<Fn0<Instant>, Long, Duration, Iterable<A>, Iterable<A>> {
    private static final RateLimit<?> INSTANCE = new RateLimit();

    private RateLimit() {
    }

    @Override
    public Iterable<A> checkedApply(Fn0<Instant> instantFn0, Long limit, Duration duration, Iterable<A> as) {
        if (limit < 1L) {
            throw new IllegalArgumentException("Limit must be greater than 0: " + limit);
        }
        return new RateLimitingIterable<A>(as, Collections.singleton(HList.tuple(limit, duration, instantFn0)));
    }

    public static <A> RateLimit<A> rateLimit() {
        return INSTANCE;
    }

    public static <A> Fn3<Long, Duration, Iterable<A>, Iterable<A>> rateLimit(Fn0<Instant> instantFn0) {
        return RateLimit.rateLimit().apply(instantFn0);
    }

    public static <A> Fn2<Duration, Iterable<A>, Iterable<A>> rateLimit(Fn0<Instant> instantFn0, Long limit) {
        return RateLimit.rateLimit(instantFn0).apply((Object)limit);
    }

    public static <A> Fn1<Iterable<A>, Iterable<A>> rateLimit(Fn0<Instant> instantFn0, Long limit, Duration duration) {
        return RateLimit.rateLimit(instantFn0, limit).apply((Object)duration);
    }

    public static <A> Iterable<A> rateLimit(Fn0<Instant> instantFn0, Long limit, Duration duration, Iterable<A> as) {
        return RateLimit.rateLimit(instantFn0, limit, duration).apply(as);
    }
}

