/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functions.recursion;

import com.jnape.palatable.lambda.adt.coproduct.CoProduct2;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Bifunctor;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Objects;

public abstract class RecursiveResult<A, B>
implements CoProduct2<A, B, RecursiveResult<A, B>>,
Bifunctor<A, B, RecursiveResult<?, ?>>,
Monad<B, RecursiveResult<A, ?>>,
Traversable<B, RecursiveResult<A, ?>> {
    private RecursiveResult() {
    }

    public RecursiveResult<B, A> invert() {
        return this.match(RecursiveResult::terminate, RecursiveResult::recurse);
    }

    public <C> RecursiveResult<C, B> biMapL(Fn1<? super A, ? extends C> fn) {
        return (RecursiveResult)Bifunctor.super.biMapL((Fn1)fn);
    }

    public <C> RecursiveResult<A, C> biMapR(Fn1<? super B, ? extends C> fn) {
        return (RecursiveResult)Bifunctor.super.biMapR((Fn1)fn);
    }

    public <C, D> RecursiveResult<C, D> biMap(Fn1<? super A, ? extends C> lFn, Fn1<? super B, ? extends D> rFn) {
        return this.match(a -> RecursiveResult.recurse(lFn.apply(a)), b -> RecursiveResult.terminate(rFn.apply((Object)b)));
    }

    @Override
    public <C> RecursiveResult<A, C> flatMap(Fn1<? super B, ? extends Monad<C, RecursiveResult<A, ?>>> f) {
        return this.match(RecursiveResult::recurse, b -> (RecursiveResult)((Monad)f.apply((Object)b)).coerce());
    }

    @Override
    public <C> RecursiveResult<A, C> pure(C c) {
        return RecursiveResult.terminate(c);
    }

    @Override
    public <C> RecursiveResult<A, C> fmap(Fn1<? super B, ? extends C> fn) {
        return (RecursiveResult)Monad.super.fmap(fn).coerce();
    }

    @Override
    public <C> RecursiveResult<A, C> zip(Applicative<Fn1<? super B, ? extends C>, RecursiveResult<A, ?>> appFn) {
        return (RecursiveResult)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <C> RecursiveResult<A, C> discardL(Applicative<C, RecursiveResult<A, ?>> appB) {
        return (RecursiveResult)Monad.super.discardL(appB).coerce();
    }

    @Override
    public <C> RecursiveResult<A, B> discardR(Applicative<C, RecursiveResult<A, ?>> appB) {
        return (RecursiveResult)Monad.super.discardR(appB).coerce();
    }

    @Override
    public <C, App extends Applicative<?, App>, TravB extends Traversable<C, RecursiveResult<A, ?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super B, ? extends Applicative<C, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)this.match(__ -> (Applicative)pure.apply((Object)this.coerce()), b -> (Applicative)((Applicative)fn.apply((B)b)).fmap((A object) -> this.pure(object)).fmap(Functor::coerce).coerce());
    }

    public static <A, B> RecursiveResult<A, B> recurse(A a) {
        return new Recurse(a);
    }

    public static <A, B> RecursiveResult<A, B> terminate(B b) {
        return new Terminate(b);
    }

    static final class Terminate<A, B>
    extends RecursiveResult<A, B> {
        final B b;

        private Terminate(B b) {
            this.b = b;
        }

        @Override
        public <R> R match(Fn1<? super A, ? extends R> aFn, Fn1<? super B, ? extends R> bFn) {
            return bFn.apply(this.b);
        }

        public boolean equals(Object other) {
            return other instanceof Terminate && Objects.equals(this.b, ((Terminate)other).b);
        }

        public int hashCode() {
            return Objects.hash(this.b);
        }

        public String toString() {
            return "Terminate{b=" + this.b + '}';
        }
    }

    static final class Recurse<A, B>
    extends RecursiveResult<A, B> {
        final A a;

        private Recurse(A a) {
            this.a = a;
        }

        @Override
        public <R> R match(Fn1<? super A, ? extends R> aFn, Fn1<? super B, ? extends R> bFn) {
            return aFn.apply(this.a);
        }

        public boolean equals(Object other) {
            return other instanceof Recurse && Objects.equals(this.a, ((Recurse)other).a);
        }

        public int hashCode() {
            return Objects.hash(this.a);
        }

        public String toString() {
            return "Recurse{a=" + this.a + '}';
        }
    }
}

