/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.functor.builtin;

import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into;
import com.jnape.palatable.lambda.functions.recursion.RecursiveResult;
import com.jnape.palatable.lambda.functions.recursion.Trampoline;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.LinkedList;
import java.util.Objects;

public abstract class Lazy<A>
implements Monad<A, Lazy<?>>,
Traversable<A, Lazy<?>> {
    private Lazy() {
    }

    public abstract A value();

    public <B> Lazy<B> flatMap(Fn1<? super A, ? extends Monad<B, Lazy<?>>> f) {
        Lazy source = this;
        Fn1<? super A, ? extends Monad<B, Lazy<?>>> flatMap = f;
        return new Compose(source, flatMap);
    }

    @Override
    public <B, App extends Applicative<?, App>, TravB extends Traversable<B, Lazy<?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super A, ? extends Applicative<B, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)((Applicative)fn.apply(this.value()).fmap((A b) -> Lazy.lazy(b)).coerce());
    }

    public final <B> Lazy<B> pure(B b) {
        return Lazy.lazy(b);
    }

    public final <B> Lazy<B> fmap(Fn1<? super A, ? extends B> fn) {
        return (Lazy)Monad.super.fmap((Fn1)fn).coerce();
    }

    public <B> Lazy<B> zip(Applicative<Fn1<? super A, ? extends B>, Lazy<?>> appFn) {
        return (Lazy)Monad.super.zip(appFn).coerce();
    }

    public final <B> Lazy<B> discardL(Applicative<B, Lazy<?>> appB) {
        return (Lazy)Monad.super.discardL(appB).coerce();
    }

    public final <B> Lazy<A> discardR(Applicative<B, Lazy<?>> appB) {
        return (Lazy)Monad.super.discardR(appB).coerce();
    }

    public boolean equals(Object other) {
        return other instanceof Lazy && Objects.equals(this.value(), ((Lazy)other).value());
    }

    public int hashCode() {
        return Objects.hash(this.value());
    }

    public String toString() {
        return "Lazy{value=" + this.value() + "}";
    }

    public static <A> Lazy<A> lazy(A value) {
        return Lazy.lazy(() -> value);
    }

    public static <A> Lazy<A> lazy(Fn0<A> fn0) {
        return new Later(fn0);
    }

    private static final class Compose<A>
    extends Lazy<A> {
        private final Lazy<Object> source;
        private final Fn1<Object, Lazy<Object>> flatMap;

        private Compose(Lazy<Object> source, Fn1<Object, Lazy<Object>> flatMap) {
            this.source = source;
            this.flatMap = flatMap;
        }

        @Override
        public A value() {
            Tuple2 tuple = HList.tuple(this, new LinkedList());
            Object a = Trampoline.trampoline(Into.into((source, flatMaps) -> {
                if (source instanceof Compose) {
                    Compose nested = (Compose)source;
                    flatMaps.push(nested.flatMap);
                    return RecursiveResult.recurse(HList.tuple(nested.source, flatMaps));
                }
                if (flatMaps.isEmpty()) {
                    return RecursiveResult.terminate(source.value());
                }
                return RecursiveResult.recurse(HList.tuple(((Fn1)flatMaps.pop()).apply(source.value()), flatMaps));
            }), tuple);
            return (A)a;
        }
    }

    private static final class Later<A>
    extends Lazy<A> {
        private final Fn0<A> fn0;

        private Later(Fn0<A> fn0) {
            this.fn0 = fn0;
        }

        @Override
        public A value() {
            return this.fn0.apply();
        }
    }
}

