/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.All;
import com.jnape.palatable.lambda.internal.iteration.FilteringIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class FilteringIterable<A>
implements Iterable<A> {
    private final List<Fn1<? super A, ? extends Boolean>> predicates;
    private final Iterable<A> as;

    public FilteringIterable(Fn1<? super A, ? extends Boolean> predicate, Iterable<A> as) {
        ArrayList<Fn1<A, Boolean>> predicates = new ArrayList<Fn1<A, Boolean>>(Collections.singletonList(predicate));
        while (as instanceof FilteringIterable) {
            FilteringIterable nested = (FilteringIterable)as;
            predicates.addAll(0, nested.predicates);
            as = nested.as;
        }
        this.predicates = predicates;
        this.as = as;
    }

    @Override
    public Iterator<A> iterator() {
        Fn1<Object, Boolean> metaPredicate = a -> All.all(p -> (Boolean)p.apply(a), this.predicates);
        return new FilteringIterator<Object>(metaPredicate, this.as.iterator());
    }
}

