/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.internal.iteration.ImmutableIterator;
import com.jnape.palatable.lambda.internal.iteration.RewindableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class FilteringIterator<A>
extends ImmutableIterator<A> {
    private final Fn1<? super A, ? extends Boolean> predicate;
    private final RewindableIterator<A> rewindableIterator;

    public FilteringIterator(Fn1<? super A, ? extends Boolean> predicate, Iterator<A> iterator) {
        this.predicate = predicate;
        this.rewindableIterator = new RewindableIterator<A>(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.rewindableIterator.isRewound() || this.hasMoreMatchingElements();
    }

    @Override
    public A next() {
        if (this.hasNext()) {
            return this.rewindableIterator.next();
        }
        throw new NoSuchElementException();
    }

    private boolean hasMoreMatchingElements() {
        while (this.rewindableIterator.hasNext()) {
            if (!this.predicate.apply(this.rewindableIterator.next()).booleanValue()) continue;
            this.rewindableIterator.rewind();
            return true;
        }
        return false;
    }
}

