/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.internal.iteration.MappingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class MappingIterable<A, B>
implements Iterable<B> {
    private final Iterable<A> as;
    private final List<Fn1<?, ?>> mappers;

    public MappingIterable(Fn1<? super A, ? extends B> fn, Iterable<A> as) {
        ArrayList<Fn1<A, B>> mappers = new ArrayList<Fn1<A, B>>(Collections.singletonList(fn));
        while (as instanceof MappingIterable) {
            MappingIterable nested = (MappingIterable)as;
            as = nested.as;
            mappers.addAll(0, nested.mappers);
        }
        this.as = as;
        this.mappers = mappers;
    }

    @Override
    public Iterator<B> iterator() {
        Fn1<Object, Object> fnComposedOnTheHeap = a -> FoldLeft.foldLeft((x, fn) -> fn.apply(x), a, this.mappers);
        return new MappingIterator<Object, Object>(fnComposedOnTheHeap, this.as.iterator());
    }
}

