/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Any;
import com.jnape.palatable.lambda.internal.iteration.PredicatedDroppingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class PredicatedDroppingIterable<A>
implements Iterable<A> {
    private final List<Fn1<? super A, ? extends Boolean>> predicates;
    private final Iterable<A> as;

    public PredicatedDroppingIterable(Fn1<? super A, ? extends Boolean> predicate, Iterable<A> as) {
        ArrayList<Fn1<A, Boolean>> predicates = new ArrayList<Fn1<A, Boolean>>(Collections.singletonList(predicate));
        while (as instanceof PredicatedDroppingIterable) {
            PredicatedDroppingIterable nested = (PredicatedDroppingIterable)as;
            as = nested.as;
            predicates.addAll(0, nested.predicates);
        }
        this.predicates = predicates;
        this.as = as;
    }

    @Override
    public Iterator<A> iterator() {
        Fn1<Object, Boolean> metaPredicate = a -> Any.any(p -> (Boolean)p.apply(a), this.predicates);
        return new PredicatedDroppingIterator<Object>(metaPredicate, this.as.iterator());
    }
}

