/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.internal.iteration.ImmutableIterator;
import com.jnape.palatable.lambda.internal.iteration.RewindableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PredicatedDroppingIterator<A>
extends ImmutableIterator<A> {
    private final Fn1<? super A, ? extends Boolean> predicate;
    private final RewindableIterator<A> rewindableIterator;
    private boolean finishedDropping;

    public PredicatedDroppingIterator(Fn1<? super A, ? extends Boolean> predicate, Iterator<A> asIterator) {
        this.predicate = predicate;
        this.rewindableIterator = new RewindableIterator<A>(asIterator);
        this.finishedDropping = false;
    }

    @Override
    public boolean hasNext() {
        this.dropElementsIfNecessary();
        return this.rewindableIterator.hasNext();
    }

    @Override
    public A next() {
        if (this.hasNext()) {
            return this.rewindableIterator.next();
        }
        throw new NoSuchElementException();
    }

    private void dropElementsIfNecessary() {
        while (this.rewindableIterator.hasNext() && !this.finishedDropping) {
            if (this.predicate.apply(this.rewindableIterator.next()).booleanValue()) continue;
            this.rewindableIterator.rewind();
            this.finishedDropping = true;
        }
    }
}

