/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.internal.iteration.ImmutableIterator;
import com.jnape.palatable.lambda.internal.iteration.RewindableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PredicatedTakingIterator<A>
extends ImmutableIterator<A> {
    private final Fn1<? super A, ? extends Boolean> predicate;
    private final RewindableIterator<A> rewindableIterator;
    private boolean stillTaking;

    public PredicatedTakingIterator(Fn1<? super A, ? extends Boolean> predicate, Iterator<A> asIterator) {
        this.predicate = predicate;
        this.rewindableIterator = new RewindableIterator<A>(asIterator);
        this.stillTaking = true;
    }

    @Override
    public boolean hasNext() {
        return this.stillTaking && this.rewindableIterator.hasNext() && this.predicateSucceedsOnNextElement();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.rewindableIterator.next();
    }

    private boolean predicateSucceedsOnNextElement() {
        if (this.rewindableIterator.isRewound()) {
            return true;
        }
        if (this.predicate.apply(this.rewindableIterator.next()).booleanValue()) {
            this.rewindableIterator.rewind();
            this.stillTaking = true;
            return true;
        }
        this.stillTaking = false;
        return false;
    }
}

