/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.adt.hlist.Tuple3;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.internal.iteration.RateLimitingIterator;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class RateLimitingIterable<A>
implements Iterable<A> {
    private final Iterable<A> as;
    private final Set<Tuple3<Long, Duration, Fn0<Instant>>> rateLimits;

    public RateLimitingIterable(Iterable<A> as, Set<Tuple3<Long, Duration, Fn0<Instant>>> rateLimits) {
        HashSet<Tuple3<Long, Duration, Fn0<Instant>>> combinedRateLimits = new HashSet<Tuple3<Long, Duration, Fn0<Instant>>>(rateLimits);
        if (as instanceof RateLimitingIterable) {
            RateLimitingIterable inner = (RateLimitingIterable)as;
            combinedRateLimits.addAll(inner.rateLimits);
            as = inner.as;
        }
        this.rateLimits = combinedRateLimits;
        this.as = as;
    }

    @Override
    public Iterator<A> iterator() {
        return new RateLimitingIterator<A>(this.as.iterator(), this.rateLimits);
    }
}

