/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.adt.Try;
import com.jnape.palatable.lambda.adt.hlist.Tuple3;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.builtin.fn1.Size;
import com.jnape.palatable.lambda.functions.builtin.fn2.Filter;
import com.jnape.palatable.lambda.functions.builtin.fn2.GTE;
import com.jnape.palatable.lambda.functions.builtin.fn2.LT;
import com.jnape.palatable.lambda.functions.builtin.fn2.LTE;
import com.jnape.palatable.lambda.internal.iteration.IterationInterruptedException;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.semigroup.builtin.Max;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class RateLimitingIterator<A>
implements Iterator<A> {
    private final Iterator<A> asIterator;
    private final Set<Tuple3<Long, Duration, Fn0<Instant>>> rateLimits;
    private final Map<Tuple3<Long, Duration, Fn0<Instant>>, List<Instant>> timeSlicesByRateLimit;

    public RateLimitingIterator(Iterator<A> asIterator, Set<Tuple3<Long, Duration, Fn0<Instant>>> rateLimits) {
        this.asIterator = asIterator;
        this.rateLimits = rateLimits;
        this.timeSlicesByRateLimit = new HashMap<Tuple3<Long, Duration, Fn0<Instant>>, List<Instant>>();
    }

    @Override
    public boolean hasNext() {
        return this.asIterator.hasNext();
    }

    @Override
    public A next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.awaitNextTimeSlice();
        return this.asIterator.next();
    }

    private void awaitNextTimeSlice() {
        this.rateLimits.forEach(rateLimit -> {
            this.awaitNextTimeSliceForRateLimit((Tuple3<Long, Duration, Fn0<Instant>>)rateLimit);
            List timeSlicesForRateLimit = this.timeSlicesByRateLimit.getOrDefault(rateLimit, new ArrayList());
            timeSlicesForRateLimit.add(((Fn0)rateLimit._3()).apply());
            this.timeSlicesByRateLimit.put((Tuple3<Long, Duration, Fn0<Instant>>)rateLimit, timeSlicesForRateLimit);
        });
    }

    private void awaitNextTimeSliceForRateLimit(Tuple3<Long, Duration, Fn0<Instant>> rateLimit) {
        while (this.rateLimitExhaustedInTimeSlice(rateLimit)) {
            ((Try)Monad.join(((Try)Try.trying(() -> Thread.sleep(0L)).fmap(Try::success)).catching(InterruptedException.class, t -> Try.failure(new IterationInterruptedException((InterruptedException)t))))).orThrow();
        }
    }

    private boolean rateLimitExhaustedInTimeSlice(Tuple3<Long, Duration, Fn0<Instant>> rateLimit) {
        List timeSlicesForRateLimit = this.timeSlicesByRateLimit.getOrDefault(rateLimit, Collections.emptyList());
        return rateLimit.into((limit, duration, instantSupplier) -> {
            Instant timeSliceEnd = (Instant)instantSupplier.apply();
            Instant previousTimeSliceEnd = timeSliceEnd.minus((TemporalAmount)duration);
            timeSlicesForRateLimit.removeIf(LT.lt(previousTimeSliceEnd).toPredicate());
            return Max.max(0L, limit - Size.size(Filter.filter(mark -> LTE.lte(mark, previousTimeSliceEnd) != false && GTE.gte(mark, timeSliceEnd) != false, timeSlicesForRateLimit))) == 0L;
        });
    }
}

