/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.internal.iteration;

import com.jnape.palatable.lambda.internal.iteration.ImmutableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class RewindableIterator<A>
extends ImmutableIterator<A> {
    private final Iterator<A> asIterator;
    private final Cache<A> cache;
    private boolean rewound;

    public RewindableIterator(Iterator<A> asIterator) {
        this.asIterator = asIterator;
        this.cache = new Cache();
        this.rewound = false;
    }

    @Override
    public boolean hasNext() {
        return this.rewound ? this.cache.isNotEmpty() : this.asIterator.hasNext();
    }

    @Override
    public A next() {
        if (this.rewound) {
            this.rewound = false;
            return this.cache.retrieve();
        }
        A next = this.asIterator.next();
        this.cache.store(next);
        return next;
    }

    public void rewind() {
        if (this.cache.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.rewound = true;
    }

    public boolean isRewound() {
        return this.rewound;
    }

    private static class Cache<A> {
        private A cache;

        private Cache() {
        }

        public void store(A a) {
            this.cache = a;
        }

        public A retrieve() {
            if (this.cache == null) {
                throw new NoSuchElementException("Cache is empty.");
            }
            A cache = this.cache;
            this.cache = null;
            return cache;
        }

        public boolean isEmpty() {
            return this.cache == null;
        }

        public boolean isNotEmpty() {
            return !this.isEmpty();
        }
    }
}

