/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.io;

import com.jnape.palatable.lambda.adt.Either;
import com.jnape.palatable.lambda.adt.Try;
import com.jnape.palatable.lambda.adt.Unit;
import com.jnape.palatable.lambda.adt.choice.Choice2;
import com.jnape.palatable.lambda.adt.hlist.HList;
import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Constantly;
import com.jnape.palatable.lambda.functions.builtin.fn2.Into;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functions.recursion.RecursiveResult;
import com.jnape.palatable.lambda.functions.recursion.Trampoline;
import com.jnape.palatable.lambda.functions.specialized.SideEffect;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.monad.Monad;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public abstract class IO<A>
implements Monad<A, IO<?>> {
    private IO() {
    }

    public abstract A unsafePerformIO();

    public final CompletableFuture<A> unsafePerformAsyncIO() {
        return this.unsafePerformAsyncIO(ForkJoinPool.commonPool());
    }

    public abstract CompletableFuture<A> unsafePerformAsyncIO(Executor var1);

    public final IO<A> exceptionally(final Fn1<? super Throwable, ? extends A> recoveryFn) {
        return new IO<A>(){

            @Override
            public A unsafePerformIO() {
                return Try.trying(IO.this::unsafePerformIO).recover(recoveryFn);
            }

            @Override
            public CompletableFuture<A> unsafePerformAsyncIO(Executor executor) {
                return IO.this.unsafePerformAsyncIO(executor).exceptionally(recoveryFn::apply);
            }
        };
    }

    public final IO<A> ensuring(IO<?> ensureIO) {
        return (IO)Monad.join(((IO)this.fmap((A a) -> ensureIO.fmap(Constantly.constantly(a)))).exceptionally(t -> (IO)Monad.join(((IO)ensureIO.fmap(Constantly.constantly(IO.io(() -> {
            throw t;
        })))).exceptionally(t2 -> IO.io(() -> {
            t.addSuppressed((Throwable)t2);
            throw t;
        })))));
    }

    public final IO<Either<Throwable, A>> safe() {
        return ((IO)this.fmap(Either::right)).exceptionally(Either::left);
    }

    public final <B> IO<B> pure(B b) {
        return IO.io(b);
    }

    public final <B> IO<B> fmap(Fn1<? super A, ? extends B> fn) {
        return (IO)Monad.super.fmap((Fn1)fn).coerce();
    }

    public final <B> IO<B> zip(Applicative<Fn1<? super A, ? extends B>, IO<?>> appFn) {
        IO source = this;
        IO zip = (IO)appFn;
        return new Compose(source, Choice2.a(zip));
    }

    @Override
    public <B> Lazy<IO<B>> lazyZip(Lazy<? extends Applicative<Fn1<? super A, ? extends B>, IO<?>>> lazyAppFn) {
        return Monad.super.lazyZip(lazyAppFn).fmap(Functor::coerce);
    }

    public final <B> IO<B> discardL(Applicative<B, IO<?>> appB) {
        return (IO)Monad.super.discardL(appB).coerce();
    }

    public final <B> IO<A> discardR(Applicative<B, IO<?>> appB) {
        return (IO)Monad.super.discardR(appB).coerce();
    }

    public final <B> IO<B> flatMap(Fn1<? super A, ? extends Monad<B, IO<?>>> f) {
        IO source = this;
        Fn1<? super A, ? extends Monad<B, IO<?>>> flatMap = f;
        return new Compose(source, Choice2.b(flatMap));
    }

    public static <A> IO<A> throwing(Throwable t) {
        return IO.io(() -> {
            throw t;
        });
    }

    public static <A> IO<A> io(final A a) {
        return new IO<A>(){

            @Override
            public A unsafePerformIO() {
                return a;
            }

            @Override
            public CompletableFuture<A> unsafePerformAsyncIO(Executor executor) {
                return CompletableFuture.completedFuture(a);
            }
        };
    }

    public static <A> IO<A> io(final Fn0<? extends A> fn0) {
        return new IO<A>(){

            @Override
            public A unsafePerformIO() {
                return fn0.apply();
            }

            @Override
            public CompletableFuture<A> unsafePerformAsyncIO(Executor executor) {
                return CompletableFuture.supplyAsync(fn0::apply, executor);
            }
        };
    }

    public static IO<Unit> io(SideEffect sideEffect) {
        return IO.io(Fn0.fn0(() -> {
            sideEffect.\u03a9();
            return Unit.UNIT;
        }));
    }

    public static <A> IO<A> externallyManaged(final Fn0<CompletableFuture<A>> supplier) {
        return new IO<A>(){

            @Override
            public A unsafePerformIO() {
                return Fn0.fn0(() -> this.unsafePerformAsyncIO().get()).apply();
            }

            @Override
            public CompletableFuture<A> unsafePerformAsyncIO(Executor executor) {
                return (CompletableFuture)supplier.apply();
            }
        };
    }

    private static final class Compose<A>
    extends IO<A> {
        private final IO<Object> source;
        private final Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>> composition;

        private Compose(IO<Object> source, Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>> composition) {
            this.source = source;
            this.composition = composition;
        }

        @Override
        public A unsafePerformIO() {
            Object result = Trampoline.trampoline(Into.into((source, compositions) -> {
                Object res = source.unsafePerformIO();
                return compositions.isEmpty() ? RecursiveResult.terminate(res) : ((Choice2)compositions.pop()).match(zip -> RecursiveResult.recurse(HList.tuple(Compose.io(((Fn1)zip.unsafePerformIO()).apply(res)), compositions)), flatMap -> {
                    IO next = (IO)flatMap.apply(res);
                    return next instanceof Compose ? RecursiveResult.recurse(((Compose)next).deforest((LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>>)compositions)) : RecursiveResult.recurse(HList.tuple(next, compositions));
                });
            }), this.deforest(new LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>>()));
            return (A)result;
        }

        @Override
        public CompletableFuture<A> unsafePerformAsyncIO(Executor executor) {
            CompletableFuture future = this.deforest(new LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>>()).into((source, compositions) -> FoldLeft.foldLeft((ioFuture, composition) -> composition.match(zip -> zip.unsafePerformAsyncIO(executor).thenComposeAsync(f -> ioFuture.thenApply(f.toFunction()), executor), flatMap -> ioFuture.thenComposeAsync(obj -> ((IO)flatMap.apply(obj)).unsafePerformAsyncIO(executor), executor)), source.unsafePerformAsyncIO(executor), compositions));
            return future;
        }

        private Tuple2<IO<Object>, LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>>> deforest(LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>> branches) {
            Tuple2<Compose, LinkedList<Choice2<IO<Fn1<Object, Object>>, Fn1<Object, IO<Object>>>>> args = HList.tuple(this, branches);
            return (Tuple2)Trampoline.trampoline(Into.into((source, compositions) -> {
                IO<Object> leaf = source.source;
                compositions.push(source.composition);
                return leaf instanceof Compose ? RecursiveResult.recurse(HList.tuple((Compose)leaf, compositions)) : RecursiveResult.terminate(HList.tuple(leaf, compositions));
            }), args);
        }
    }
}

