/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.monoid;

import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Id;
import com.jnape.palatable.lambda.functions.builtin.fn1.Reverse;
import com.jnape.palatable.lambda.functions.builtin.fn2.Cons;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.semigroup.Semigroup;

public interface Monoid<A>
extends Semigroup<A> {
    public A identity();

    default public A reduceLeft(Iterable<A> as) {
        return this.foldMap(Id.id(), as);
    }

    default public A reduceRight(Iterable<A> as) {
        return this.flip().foldMap(Id.id(), Reverse.reverse(as));
    }

    default public <B> A foldMap(Fn1<? super B, ? extends A> fn, Iterable<B> bs) {
        return FoldLeft.foldLeft(this, this.identity(), Map.map(fn, bs));
    }

    @Override
    default public A foldLeft(A a, Iterable<A> as) {
        return this.foldMap(Id.id(), Cons.cons(a, as));
    }

    @Override
    default public Lazy<A> foldRight(A a, Iterable<A> as) {
        return Lazy.lazy(() -> this.flip().foldMap(Id.id(), Reverse.reverse(Cons.cons(a, as))));
    }

    @Override
    default public Monoid<A> flip() {
        return Monoid.monoid(Semigroup.super.flip(), this.identity());
    }

    public static <A> Monoid<A> monoid(final Semigroup<A> semigroup, final A identity) {
        return new Monoid<A>(){

            @Override
            public A identity() {
                return identity;
            }

            @Override
            public A checkedApply(A x, A y) {
                return semigroup.apply(x, y);
            }
        };
    }

    public static <A> Monoid<A> monoid(final Semigroup<A> semigroup, final Fn0<A> identityFn0) {
        return new Monoid<A>(){

            @Override
            public A identity() {
                return identityFn0.apply();
            }

            @Override
            public A checkedApply(A x, A y) {
                return semigroup.apply(x, y);
            }
        };
    }
}

