/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.monoid.builtin;

import com.jnape.palatable.lambda.functions.Fn0;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldLeft;
import com.jnape.palatable.lambda.functions.specialized.MonoidFactory;
import com.jnape.palatable.lambda.monoid.Monoid;
import java.util.Collection;

public final class AddAll<A, C extends Collection<A>>
implements MonoidFactory<Fn0<C>, C> {
    private static final AddAll<?, ?> INSTANCE = new AddAll();

    private AddAll() {
    }

    @Override
    public Monoid<C> checkedApply(final Fn0<C> cFn0) {
        return new Monoid<C>(){

            @Override
            public C identity() {
                return (Collection)cFn0.apply();
            }

            @Override
            public C checkedApply(C xs, C ys) {
                Object c = this.identity();
                c.addAll(xs);
                c.addAll(ys);
                return c;
            }

            @Override
            public <B> C foldMap(Fn1<? super B, ? extends C> fn, Iterable<B> bs) {
                return (Collection)FoldLeft.foldLeft((x, y) -> {
                    x.addAll(y);
                    return x;
                }, this.identity(), Map.map(fn, bs));
            }
        };
    }

    public static <A, C extends Collection<A>> AddAll<A, C> addAll() {
        return INSTANCE;
    }

    public static <A, C extends Collection<A>> Monoid<C> addAll(Fn0<C> collectionFn0) {
        return AddAll.addAll().apply(collectionFn0);
    }

    public static <A, C extends Collection<A>> Fn1<C, C> addAll(Fn0<C> collectionFn0, C xs) {
        return AddAll.addAll(collectionFn0).apply((Object)xs);
    }

    public static <A, C extends Collection<A>> C addAll(Fn0<C> collectionFn0, C xs, C ys) {
        return (C)((Collection)AddAll.addAll(collectionFn0, xs).apply(ys));
    }
}

