/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.monoid.builtin;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Flatten;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.internal.iteration.ConcatenatingIterable;
import com.jnape.palatable.lambda.monoid.Monoid;
import java.util.Collections;

public final class Concat<A>
implements Monoid<Iterable<A>> {
    private static final Concat<?> INSTANCE = new Concat();

    private Concat() {
    }

    @Override
    public Iterable<A> identity() {
        return Collections::emptyIterator;
    }

    @Override
    public Iterable<A> checkedApply(Iterable<A> xs, Iterable<A> ys) {
        return new ConcatenatingIterable<A>(xs, ys);
    }

    @Override
    public <B> Iterable<A> foldMap(Fn1<? super B, ? extends Iterable<A>> fn, Iterable<B> bs) {
        return Flatten.flatten(Map.map(fn, bs));
    }

    public static <A> Concat<A> concat() {
        return INSTANCE;
    }

    public static <A> Fn1<Iterable<A>, Iterable<A>> concat(Iterable<A> xs) {
        return Concat.concat().apply(xs);
    }

    public static <A> Iterable<A> concat(Iterable<A> xs, Iterable<A> ys) {
        return Concat.concat(xs).apply(ys);
    }
}

