/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.optics;

import com.jnape.palatable.lambda.adt.hlist.Tuple2;
import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.Fn2;
import com.jnape.palatable.lambda.functions.builtin.fn2.Both;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.Profunctor;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.optics.Iso;
import com.jnape.palatable.lambda.optics.Optic;
import com.jnape.palatable.lambda.optics.functions.Set;
import com.jnape.palatable.lambda.optics.functions.View;

@FunctionalInterface
public interface Lens<S, T, A, B>
extends Optic<Fn1<?, ?>, Functor<?, ?>, S, T, A, B>,
Monad<T, Lens<S, ?, A, B>>,
Profunctor<S, T, Lens<?, ?, A, B>> {
    default public <U> Lens<S, U, A, B> fmap(Fn1<? super T, ? extends U> fn) {
        return (Lens)Monad.super.fmap(fn).coerce();
    }

    default public <U> Lens<S, U, A, B> pure(U u) {
        return Lens.lens(View.view(this), (s, b) -> u);
    }

    default public <U> Lens<S, U, A, B> zip(Applicative<Fn1<? super T, ? extends U>, Lens<S, ?, A, B>> appFn) {
        return (Lens)Monad.super.zip(appFn).coerce();
    }

    default public <U> Lens<S, U, A, B> discardL(Applicative<U, Lens<S, ?, A, B>> appB) {
        return (Lens)Monad.super.discardL(appB).coerce();
    }

    default public <U> Lens<S, T, A, B> discardR(Applicative<U, Lens<S, ?, A, B>> appB) {
        return (Lens)Monad.super.discardR(appB).coerce();
    }

    default public <U> Lens<S, U, A, B> flatMap(Fn1<? super T, ? extends Monad<U, Lens<S, ?, A, B>>> f) {
        return Lens.lens(View.view(this), (s, b) -> Set.set((Optic)((Monad)f.apply((T)Set.set(this, b, s))).coerce(), b, s));
    }

    default public <R> Lens<R, T, A, B> diMapL(Fn1<? super R, ? extends S> fn) {
        return (Lens)Profunctor.super.diMapL(fn);
    }

    default public <U> Lens<S, U, A, B> diMapR(Fn1<? super T, ? extends U> fn) {
        return (Lens)Profunctor.super.diMapR(fn);
    }

    default public <R, U> Lens<R, U, A, B> diMap(Fn1<? super R, ? extends S> lFn, Fn1<? super T, ? extends U> rFn) {
        return this.mapS((Fn1)lFn).mapT((Fn1)rFn);
    }

    default public <R> Lens<R, T, A, B> contraMap(Fn1<? super R, ? extends S> fn) {
        return (Lens)Profunctor.super.contraMap(fn);
    }

    default public <R> Lens<R, T, A, B> mapS(Fn1<? super R, ? extends S> fn) {
        return Lens.lens(Optic.super.mapS(fn));
    }

    default public <U> Lens<S, U, A, B> mapT(Fn1<? super T, ? extends U> fn) {
        return Lens.lens(Optic.super.mapT(fn));
    }

    default public <C> Lens<S, T, C, B> mapA(Fn1<? super A, ? extends C> fn) {
        return Lens.lens(Optic.super.mapA(fn));
    }

    default public <Z> Lens<S, T, A, Z> mapB(Fn1<? super Z, ? extends B> fn) {
        return Lens.lens(Optic.super.mapB(fn));
    }

    default public Iso<S, T, A, B> toIso(S s) {
        return Iso.iso(View.view(this), Set.set(this).flip().apply(s));
    }

    default public <C, D> Lens<S, T, C, D> andThen(Optic<? super Fn1<?, ?>, ? super Functor<?, ?>, A, B, C, D> f) {
        return Lens.lens(Optic.super.andThen(f));
    }

    default public <R, U> Lens<R, U, A, B> compose(Optic<? super Fn1<?, ?>, ? super Functor<?, ?>, R, U, S, T> g) {
        return Lens.lens(Optic.super.compose(g));
    }

    public static <S, T, A, B> Lens<S, T, A, B> lens(Fn1<? super S, ? extends A> getter, Fn2<? super S, ? super B, ? extends T> setter) {
        return Lens.lens(Optic.optic(afb -> s -> ((Functor)afb.apply(getter.apply((Object)s))).fmap((? super A b) -> setter.apply((Object)s, (Object)b))));
    }

    public static <S, T, A, B> Lens<S, T, A, B> lens(final Optic<? super Fn1<?, ?>, ? super Functor<?, ?>, S, T, A, B> optic) {
        return new Lens<S, T, A, B>(){

            @Override
            public <CoP extends Profunctor<?, ?, ? extends Fn1<?, ?>>, CoF extends Functor<?, ? extends Functor<?, ?>>, FB extends Functor<B, ? extends CoF>, FT extends Functor<T, ? extends CoF>, PAFB extends Profunctor<A, FB, ? extends CoP>, PSFT extends Profunctor<S, FT, ? extends CoP>> PSFT apply(PAFB pafb) {
                return optic.apply(pafb);
            }
        };
    }

    public static <S, A> Simple<S, A> simpleLens(Fn1<? super S, ? extends A> getter, Fn2<? super S, ? super A, ? extends S> setter) {
        return Simple.adapt(Lens.lens(getter, setter));
    }

    public static <S, A, B, C, D> Lens<S, S, Tuple2<A, B>, Tuple2<C, D>> both(Lens<S, S, A, C> f, Lens<S, S, B, D> g) {
        return Lens.lens(Both.both(View.view(f), View.view(g)), (s, cd) -> cd.biMap((Fn1)Set.set(f), (Fn1)Set.set(g)).into(Fn1::contraMap).apply(s));
    }

    public static <S, A, B> Simple<S, Tuple2<A, B>> both(Simple<S, A> f, Simple<S, B> g) {
        return Simple.adapt(Lens.both(f, g));
    }

    @FunctionalInterface
    public static interface Simple<S, A>
    extends Lens<S, S, A, A>,
    Optic.Simple<Fn1<?, ?>, Functor<?, ?>, S, A> {
        default public <B> Simple<S, B> andThen(Optic.Simple<? super Fn1<?, ?>, ? super Functor<?, ?>, A, B> f) {
            return Simple.adapt(Lens.super.andThen(f));
        }

        default public <R> Simple<R, A> compose(Optic.Simple<? super Fn1<?, ?>, ? super Functor<?, ?>, R, S> g) {
            return Simple.adapt(Lens.super.compose(g));
        }

        public static <S, A> Simple<S, A> adapt(final Optic<? super Fn1<?, ?>, ? super Functor<?, ?>, S, S, A, A> lens) {
            return new Simple<S, A>(){

                @Override
                public <CoP extends Profunctor<?, ?, ? extends Fn1<?, ?>>, CoF extends Functor<?, ? extends Functor<?, ?>>, FB extends Functor<A, ? extends CoF>, FT extends Functor<S, ? extends CoF>, PAFB extends Profunctor<A, FB, ? extends CoP>, PSFT extends Profunctor<S, FT, ? extends CoP>> PSFT apply(PAFB pafb) {
                    return lens.apply(pafb);
                }
            };
        }

        public static <S, A, B> Simple<S, Tuple2<A, B>> both(Lens<S, S, A, A> f, Lens<S, S, B, B> g) {
            return Simple.adapt(Lens.both(f, g));
        }
    }
}

