/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.optics.lenses;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.optics.Lens;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public final class CollectionLens {
    private CollectionLens() {
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, CX> asCopy(Fn1<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(copyFn, (__, copy) -> copy);
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Set<X>> asSet(Fn1<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(HashSet::new, (xsL, xsS) -> {
            HashSet missing = new HashSet(xsS);
            missing.removeAll((Collection<?>)xsL);
            Collection updated = (Collection)copyFn.apply((Object)xsL);
            updated.addAll(missing);
            updated.retainAll((Collection<?>)xsS);
            return updated;
        });
    }

    public static <X, CX extends Collection<X>> Lens.Simple<CX, Stream<X>> asStream(Fn1<? super CX, ? extends CX> copyFn) {
        return Lens.simpleLens(Collection::stream, (xsL, xsS) -> {
            Collection updated = (Collection)copyFn.apply((Object)xsL);
            updated.clear();
            xsS.forEach(updated::add);
            return updated;
        });
    }
}

