/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.optics.lenses;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.functions.builtin.fn1.Repeat;
import com.jnape.palatable.lambda.functions.builtin.fn2.Take;
import com.jnape.palatable.lambda.optics.Lens;
import com.jnape.palatable.lambda.optics.lenses.MaybeLens;
import java.util.ArrayList;
import java.util.List;

public final class ListLens {
    private ListLens() {
    }

    public static <X> Lens.Simple<List<X>, List<X>> asCopy() {
        return Lens.simpleLens(ArrayList::new, (xs, ys) -> ys);
    }

    public static <X> Lens.Simple<List<X>, Maybe<X>> elementAt(int index) {
        return Lens.simpleLens(xs -> Maybe.maybe(xs.size() > index ? (Object)xs.get(index) : null), (xs, maybeX) -> {
            ArrayList updated = new ArrayList(xs);
            return ((Maybe)maybeX.fmap(x -> {
                int minimumSize = index + 1;
                if (minimumSize > xs.size()) {
                    Take.take(Math.abs(updated.size() - minimumSize), Repeat.repeat(null)).forEach(updated::add);
                }
                updated.set(index, x);
                return updated;
            })).orElseGet(() -> {
                if (updated.size() > index) {
                    updated.set(index, null);
                }
                return updated;
            });
        });
    }

    public static <X> Lens.Simple<List<X>, X> elementAt(int index, X defaultValue) {
        return Lens.Simple.adapt(MaybeLens.unLiftB(MaybeLens.unLiftA(ListLens.elementAt(index), defaultValue)));
    }
}

