/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.optics.lenses;

import com.jnape.palatable.lambda.adt.Maybe;
import com.jnape.palatable.lambda.optics.Lens;

public final class MaybeLens {
    private MaybeLens() {
    }

    public static <S, T, A, B> Lens<Maybe<S>, T, A, B> liftS(Lens<S, T, A, B> lens, S defaultS) {
        return lens.mapS(m -> m.orElse(defaultS));
    }

    public static <S, T, A, B> Lens<S, Maybe<T>, A, B> liftT(Lens<S, T, A, B> lens) {
        return lens.mapT(Maybe::just);
    }

    public static <S, T, A, B> Lens<S, T, Maybe<A>, B> liftA(Lens<S, T, A, B> lens) {
        return lens.mapA(Maybe::just);
    }

    public static <S, T, A, B> Lens<S, T, A, Maybe<B>> liftB(Lens<S, T, A, B> lens, B defaultB) {
        return lens.mapB(m -> m.orElse(defaultB));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftS(Lens<Maybe<S>, T, A, B> lens) {
        return lens.mapS(Maybe::just);
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftT(Lens<S, Maybe<T>, A, B> lens, T defaultT) {
        return lens.mapT(m -> m.orElse(defaultT));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftA(Lens<S, T, Maybe<A>, B> lens, A defaultA) {
        return lens.mapA(m -> m.orElse(defaultA));
    }

    public static <S, T, A, B> Lens<S, T, A, B> unLiftB(Lens<S, T, A, Maybe<B>> lens) {
        return lens.mapB(Maybe::just);
    }

    public static <V> Lens.Simple<V, Maybe<V>> asMaybe() {
        return Lens.simpleLens(Maybe::maybe, (v, maybeV) -> maybeV.orElse(v));
    }
}

