/*
 * Decompiled with CFR 0.152.
 */
package com.jnape.palatable.lambda.traversable;

import com.jnape.palatable.lambda.functions.Fn1;
import com.jnape.palatable.lambda.functions.builtin.fn1.Empty;
import com.jnape.palatable.lambda.functions.builtin.fn1.Flatten;
import com.jnape.palatable.lambda.functions.builtin.fn2.Cons;
import com.jnape.palatable.lambda.functions.builtin.fn2.Map;
import com.jnape.palatable.lambda.functions.builtin.fn3.FoldRight;
import com.jnape.palatable.lambda.functor.Applicative;
import com.jnape.palatable.lambda.functor.Functor;
import com.jnape.palatable.lambda.functor.builtin.Lazy;
import com.jnape.palatable.lambda.monad.Monad;
import com.jnape.palatable.lambda.traversable.Traversable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;

public final class LambdaIterable<A>
implements Monad<A, LambdaIterable<?>>,
Traversable<A, LambdaIterable<?>> {
    private final Iterable<A> as;

    private LambdaIterable(Iterable<? extends A> as) {
        this.as = as;
    }

    public Iterable<A> unwrap() {
        return this.as;
    }

    public <B> LambdaIterable<B> fmap(Fn1<? super A, ? extends B> fn) {
        return LambdaIterable.wrap(Map.map(fn, this.as));
    }

    public <B> LambdaIterable<B> pure(B b) {
        return LambdaIterable.wrap(Collections.singleton(b));
    }

    public <B> LambdaIterable<B> zip(Applicative<Fn1<? super A, ? extends B>, LambdaIterable<?>> appFn) {
        return (LambdaIterable)Monad.super.zip(appFn).coerce();
    }

    @Override
    public <B> Lazy<LambdaIterable<B>> lazyZip(Lazy<? extends Applicative<Fn1<? super A, ? extends B>, LambdaIterable<?>>> lazyAppFn) {
        return Empty.empty(this.as) != false ? Lazy.lazy(LambdaIterable.empty()) : Monad.super.lazyZip(lazyAppFn).fmap(Functor::coerce);
    }

    public <B> LambdaIterable<B> discardL(Applicative<B, LambdaIterable<?>> appB) {
        return (LambdaIterable)Monad.super.discardL(appB).coerce();
    }

    public <B> LambdaIterable<A> discardR(Applicative<B, LambdaIterable<?>> appB) {
        return (LambdaIterable)Monad.super.discardR(appB).coerce();
    }

    public <B> LambdaIterable<B> flatMap(Fn1<? super A, ? extends Monad<B, LambdaIterable<?>>> f) {
        return LambdaIterable.wrap(Flatten.flatten(Map.map(a -> ((LambdaIterable)((Monad)f.apply(a)).coerce()).unwrap(), this.as)));
    }

    @Override
    public <B, App extends Applicative<?, App>, TravB extends Traversable<B, LambdaIterable<?>>, AppTrav extends Applicative<TravB, App>> AppTrav traverse(Fn1<? super A, ? extends Applicative<B, App>> fn, Fn1<? super TravB, ? extends AppTrav> pure) {
        return (AppTrav)((Applicative)FoldRight.foldRight((a, lglb) -> ((Applicative)fn.apply(a)).lazyZip(lglb.fmap((A appTrav) -> appTrav.fmap((A travB) -> b -> LambdaIterable.wrap(Cons.cons(b, ((LambdaIterable)travB).unwrap()))))).fmap((A appTrav) -> appTrav), Lazy.lazy(pure.apply(LambdaIterable.empty())), this.as).value());
    }

    public boolean equals(Object other) {
        if (other instanceof LambdaIterable) {
            Iterator<A> xs = this.as.iterator();
            Iterator<A> ys = ((LambdaIterable)other).as.iterator();
            while (xs.hasNext() && ys.hasNext()) {
                if (Objects.equals(xs.next(), ys.next())) continue;
                return false;
            }
            return xs.hasNext() == ys.hasNext();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.as);
    }

    public static <A> LambdaIterable<A> wrap(Iterable<? extends A> as) {
        return new LambdaIterable<A>(as);
    }

    public static <A> LambdaIterable<A> empty() {
        return LambdaIterable.wrap(Collections.emptyList());
    }
}

