/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues;

import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CollaboratorService;
import org.eclipse.egit.github.core.service.LabelService;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.github.core.service.UserService;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;

public final class GitHubCache {
    private static final Map<String, GitHubCache> CACHES = Collections.synchronizedMap(new HashMap());
    private List<User> collaborators;
    private final Map<String, List<Milestone>> milestoneMap = Collections.synchronizedMap(new HashMap());
    private List<Label> labels;
    private List<RepositoryBranch> branches;
    private List<Repository> forks;
    private User myself;
    private final Map<String, Icon> userIcons = new HashMap<String, Icon>();
    private final GitHubRepository repository;
    private static final Logger LOGGER = Logger.getLogger(GitHubCache.class.getName());
    private static final Map<String, User> USERS = Collections.synchronizedMap(new HashMap());

    private GitHubCache(GitHubRepository repository) {
        this.repository = repository;
    }

    public static synchronized GitHubCache create(@NonNull GitHubRepository repository) {
        String id = repository.getID();
        GitHubCache cache = CACHES.get(id);
        if (cache != null) {
            return cache;
        }
        cache = new GitHubCache(repository);
        CACHES.put(id, cache);
        return cache;
    }

    public synchronized void clear(GitHubRepository repository) {
        CACHES.remove(repository.getID());
    }

    public synchronized List<User> getCollaborators() {
        if (this.collaborators == null) {
            Repository ghRepository = this.repository.getRepository();
            GitHubClient client = this.repository.createGitHubClient();
            if (client == null) {
                return Collections.emptyList();
            }
            CollaboratorService collaboratorService = new CollaboratorService(client);
            try {
                this.collaborators = collaboratorService.getCollaborators((IRepositoryIdProvider)ghRepository);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get collaborators. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return this.collaborators;
    }

    public List<Milestone> getMilestones(String state) {
        return this.getMilestones(state, false);
    }

    public synchronized List<Milestone> getMilestones(String state, boolean force) {
        List milestone = this.milestoneMap.get(state);
        if (milestone == null || force) {
            if (milestone != null) {
                milestone.clear();
            }
            Repository gHRepository = this.repository.getRepository();
            GitHubClient client = this.repository.createGitHubClient();
            if (client == null) {
                return Collections.emptyList();
            }
            MilestoneService milestoneService = new MilestoneService(client);
            try {
                milestone = milestoneService.getMilestones((IRepositoryIdProvider)gHRepository, state);
                this.milestoneMap.put(state, milestone);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get milestones. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return milestone;
    }

    public List<Label> getLabels() {
        return this.getLabels(false);
    }

    public synchronized List<Label> getLabels(boolean force) {
        if (this.labels == null || force) {
            GitHubClient client;
            if (this.labels != null) {
                this.labels.clear();
            }
            if ((client = this.repository.createGitHubClient()) == null) {
                return Collections.emptyList();
            }
            LabelService labelService = new LabelService(client);
            Repository ghRepository = this.repository.getRepository();
            try {
                this.labels = labelService.getLabels((IRepositoryIdProvider)ghRepository);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get labels. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return this.labels;
    }

    @CheckForNull
    public synchronized User getMySelf() {
        if (this.myself == null) {
            GitHubClient client = this.repository.createGitHubClient();
            if (client == null) {
                return null;
            }
            UserService userService = new UserService(client);
            try {
                this.myself = userService.getUser();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get myself. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return this.myself;
    }

    @CheckForNull
    public synchronized Icon getUserIcon(User user) {
        if (user == null) {
            return null;
        }
        String login = user.getLogin();
        Icon icon = this.userIcons.get(login);
        if (icon != null) {
            return icon;
        }
        GitHubClient client = this.repository.createGitHubClient();
        if (client == null) {
            return null;
        }
        UserService userService = new UserService(client);
        try {
            user = userService.getUser(login);
            String avatarUrl = user.getAvatarUrl();
            if (avatarUrl != null && !avatarUrl.isEmpty()) {
                URL url = new URL(avatarUrl);
                BufferedImage image = ImageIO.read(url);
                Image resizedImage = image.getScaledInstance(16, 16, 4);
                icon = new ImageIcon(resizedImage);
                this.userIcons.put(login, icon);
                return icon;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage());
        }
        return null;
    }

    public List<RepositoryBranch> getBranches() {
        return this.getBranches(false);
    }

    public synchronized List<RepositoryBranch> getBranches(boolean force) {
        if (this.branches == null || force) {
            GitHubClient client;
            if (this.branches != null) {
                this.branches.clear();
            }
            if ((client = this.repository.createGitHubClient()) == null) {
                return Collections.emptyList();
            }
            RepositoryService service = new RepositoryService(client);
            Repository ghRepository = this.repository.getRepository();
            try {
                this.branches = service.getBranches((IRepositoryIdProvider)ghRepository);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get branches. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return this.branches;
    }

    public List<Repository> getForks() {
        return this.getForks(false);
    }

    public synchronized List<Repository> getForks(boolean force) {
        if (this.forks == null || force) {
            GitHubClient client;
            if (this.forks != null) {
                this.forks.clear();
            }
            if ((client = this.repository.createGitHubClient()) == null) {
                return Collections.emptyList();
            }
            RepositoryService service = new RepositoryService(client);
            Repository ghRepository = this.repository.getRepository();
            try {
                this.forks = service.getForks((IRepositoryIdProvider)ghRepository);
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "{0} : Can''t get forks. {1}", new Object[]{this.repository.getFullName(), ex.getMessage()});
            }
        }
        return this.forks;
    }

    @CheckForNull
    public static synchronized User getUser(String oAuthToken, String hostname) {
        if (StringUtils.isEmpty(oAuthToken)) {
            return null;
        }
        User user = USERS.get(oAuthToken);
        if (user == null) {
            GitHubClient client = hostname == null || hostname.isEmpty() ? new GitHubClient().setOAuth2Token(oAuthToken) : new GitHubClient(hostname).setOAuth2Token(oAuthToken);
            UserService userService = new UserService(client);
            try {
                user = userService.getUser();
                if (user != null) {
                    USERS.put(oAuthToken, user);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Can''t get user. {0}", ex.getMessage());
            }
        }
        return user;
    }
}

