/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues;

import com.junichi11.netbeans.modules.github.issues.Bundle;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.query.GitHubQuery;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class GitHubIssuesConfig {
    private static final GitHubIssuesConfig INSTANCE = new GitHubIssuesConfig();
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private static final String QUERY = "query";
    private static final String QUERY_PARAMS = "query.params";
    private static final String SCHEDULE = "schedule";
    private static final String SCHEDULE_DUE_DATE = "schedule.due";
    private static final String SCHEDULE_INTERVAL = "schedule.interval";
    private static final String TEMPLATE = "template";
    public static final String DEFAULT_TEMPLATE_NAME = "default";
    private static final String STATUS = "status";
    private static final String STATUS_FORMAT = "%s::%s";
    private static final String STATUS_DELIMITER = "::";

    private GitHubIssuesConfig() {
    }

    public static GitHubIssuesConfig getInstance() {
        return INSTANCE;
    }

    public String[] getQueryNames(GitHubRepository repository) {
        Preferences preferences = this.getPreferences(repository).node(QUERY);
        try {
            return preferences.childrenNames();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new String[0];
        }
    }

    public String getQueryParams(GitHubRepository repository, String queryName) {
        Preferences preferences = this.getPreferences(repository).node(QUERY).node(queryName);
        return preferences.get(QUERY_PARAMS, null);
    }

    public void setQueryParams(GitHubRepository repository, GitHubQuery query) {
        Preferences preferences = this.getPreferences(repository).node(QUERY).node(query.getDisplayName());
        preferences.put(QUERY_PARAMS, query.getQueryParam());
    }

    public void removeQuery(GitHubRepository repository, GitHubQuery query) {
        String displayName = query.getDisplayName();
        if (StringUtils.isEmpty(displayName)) {
            return;
        }
        Preferences preferences = this.getPreferences(repository).node(QUERY).node(displayName);
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setScheduleDueDate(GitHubRepository repository, GitHubIssue issue, Date dueDate) {
        Preferences preferences = this.getPreferences(repository);
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return;
        }
        preferences.node(SCHEDULE).node(id).put(SCHEDULE_DUE_DATE, DATE_FORMAT.format(dueDate));
    }

    public Date getScheduleDueDate(GitHubRepository repository, GitHubIssue issue) {
        Preferences preferences = this.getPreferences(repository);
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        String dateString = preferences.node(SCHEDULE).node(id).get(SCHEDULE_DUE_DATE, null);
        if (StringUtils.isEmpty(dateString)) {
            return null;
        }
        try {
            return DateFormat.getDateInstance().parse(dateString);
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void setScheduleInterval(GitHubRepository repository, GitHubIssue issue, int interval) {
        Preferences preferences = this.getPreferences(repository);
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return;
        }
        preferences.node(SCHEDULE).node(id).putInt(SCHEDULE_INTERVAL, interval);
    }

    public int getScheduleInterval(GitHubRepository repository, GitHubIssue issue) {
        Preferences preferences = this.getPreferences(repository);
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return -1;
        }
        return preferences.node(SCHEDULE).node(id).getInt(SCHEDULE_INTERVAL, -1);
    }

    public void removeSchedule(GitHubRepository repository, GitHubIssue issue) {
        Preferences preferences = this.getPreferences(repository);
        String id = issue.getID();
        if (StringUtils.isEmpty(id)) {
            return;
        }
        preferences = preferences.node(SCHEDULE).node(id);
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getTemplate(String name) {
        return this.getPreferences().node(TEMPLATE).get(name, Bundle.GitHubIssuesConfig_default_template());
    }

    public void setTemplate(String name, String template) {
        this.getPreferences().node(TEMPLATE).put(name, template);
    }

    public void removeTemplate(String name) {
        this.getPreferences().node(TEMPLATE).remove(name);
    }

    public String[] getTemplateNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DEFAULT_TEMPLATE_NAME);
        Preferences preferences = this.getPreferences().node(TEMPLATE);
        try {
            String[] childrenNames = preferences.keys();
            int count = 1;
            for (String childName : childrenNames) {
                if (childName.equals(DEFAULT_TEMPLATE_NAME)) continue;
                names.add(childName);
                ++count;
            }
            return names.toArray(new String[count]);
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return names.toArray(new String[1]);
        }
    }

    public IssueStatusProvider.Status getStatus(GitHubIssue issue) {
        long lastUpdatedTime;
        GitHubRepository repository = issue.getRepository();
        Preferences preferences = this.getPreferences().node(repository.getID()).node(STATUS);
        String statusTime = preferences.get(issue.getID(), null);
        if (statusTime == null) {
            return IssueStatusProvider.Status.INCOMING_NEW;
        }
        String[] split = statusTime.split(STATUS_DELIMITER);
        if (split.length != 2) {
            return IssueStatusProvider.Status.INCOMING_NEW;
        }
        IssueStatusProvider.Status status = IssueStatusProvider.Status.valueOf((String)split[0]);
        long lastUpdated = Long.parseLong(split[1]);
        if (status == IssueStatusProvider.Status.SEEN && (lastUpdatedTime = issue.getLastUpdatedTime()) != -1L && lastUpdated < lastUpdatedTime) {
            this.setStatus(issue, IssueStatusProvider.Status.INCOMING_MODIFIED);
            return IssueStatusProvider.Status.INCOMING_MODIFIED;
        }
        return status;
    }

    public void setStatus(GitHubIssue issue, IssueStatusProvider.Status status) {
        long lastUpdatedTime = issue.getLastUpdatedTime();
        if (lastUpdatedTime != -1L) {
            GitHubRepository repository = issue.getRepository();
            Preferences preferences = this.getPreferences().node(repository.getID()).node(STATUS);
            preferences.put(issue.getID(), String.format(STATUS_FORMAT, status.name(), lastUpdatedTime));
        }
    }

    public void removeRepository(GitHubRepository repository) {
        Preferences preferences = this.getPreferences(repository);
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(GitHubIssuesConfig.class);
    }

    private Preferences getPreferences(GitHubRepository repository) {
        String id = repository.getID();
        return this.getPreferences().node(id);
    }
}

