/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.egit;

import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.openide.util.Pair;

public class SearchIssuesParams {
    private final List<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
    private final List<Pair<String, String>> qParameters = new ArrayList<Pair<String, String>>();
    private String qKeyword = "";

    public SearchIssuesParams keyword(String keyword) {
        if (keyword == null) {
            keyword = "";
        }
        this.qKeyword = keyword;
        return this;
    }

    public SearchIssuesParams milestone(Milestone milestone) {
        if (milestone != null) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"milestone", (Object)milestone.getTitle()));
        }
        return this;
    }

    public SearchIssuesParams milestone(String milestone) {
        if (!StringUtils.isEmpty(milestone)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"milestone", (Object)milestone));
        }
        return this;
    }

    public SearchIssuesParams type(Type type) {
        if (type != null) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"type", (Object)type.getValue()));
        }
        return this;
    }

    public SearchIssuesParams in(List<In> ins) {
        StringBuilder sb = new StringBuilder();
        for (In in : ins) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(in.getValue());
        }
        String inString = sb.toString();
        if (!StringUtils.isEmpty(inString)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"in", (Object)inString));
        }
        return this;
    }

    public SearchIssuesParams in(String in) {
        if (!StringUtils.isEmpty(in)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"in", (Object)in));
        }
        return this;
    }

    public SearchIssuesParams is(Is is) {
        if (is != null) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"is", (Object)is.getValue()));
        }
        return this;
    }

    public SearchIssuesParams author(String author) {
        if (!StringUtils.isEmpty(author)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"author", (Object)author));
        }
        return this;
    }

    public SearchIssuesParams assignee(String assignee) {
        if (!StringUtils.isEmpty(assignee)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"assignee", (Object)assignee));
        }
        return this;
    }

    public SearchIssuesParams mentions(String mentions) {
        if (!StringUtils.isEmpty(mentions)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"mentions", (Object)mentions));
        }
        return this;
    }

    public SearchIssuesParams commenter(String commenter) {
        if (!StringUtils.isEmpty(commenter)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"commenter", (Object)commenter));
        }
        return this;
    }

    public SearchIssuesParams involves(String involves) {
        if (!StringUtils.isEmpty(involves)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"involves", (Object)involves));
        }
        return this;
    }

    public SearchIssuesParams team(String team) {
        if (!StringUtils.isEmpty(team)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"team", (Object)team));
        }
        return this;
    }

    public SearchIssuesParams state(State state) {
        if (state != null) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"state", (Object)state.getValue()));
        }
        return this;
    }

    public SearchIssuesParams labels(String labels) {
        if (!StringUtils.isEmpty(labels)) {
            String[] splits;
            for (String s : splits = labels.split(",")) {
                if (s.isEmpty()) continue;
                this.qParameters.add((Pair<String, String>)Pair.of((Object)"label", (Object)s.trim()));
            }
        }
        return this;
    }

    public SearchIssuesParams labels(List<Label> labels) {
        for (Label label : labels) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"label", (Object)label.getName()));
        }
        return this;
    }

    public SearchIssuesParams no(No no) {
        if (no != null) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"no", (Object)no.getValue()));
        }
        return this;
    }

    public SearchIssuesParams language(String language) {
        if (!StringUtils.isEmpty(language)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"language", (Object)language));
        }
        return this;
    }

    public SearchIssuesParams is(List<Is> ises) {
        for (Is is : ises) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"is", (Object)is.getValue()));
        }
        return this;
    }

    public SearchIssuesParams created(String created) {
        if (!StringUtils.isEmpty(created)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"created", (Object)created));
        }
        return this;
    }

    public SearchIssuesParams updated(String updated) {
        if (!StringUtils.isEmpty(updated)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"updated", (Object)updated));
        }
        return this;
    }

    public SearchIssuesParams merged(String merged) {
        if (!StringUtils.isEmpty(merged)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"merged", (Object)merged));
        }
        return this;
    }

    public SearchIssuesParams closed(String closed) {
        if (!StringUtils.isEmpty(closed)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"closed", (Object)closed));
        }
        return this;
    }

    public SearchIssuesParams comments(String comments) {
        if (!StringUtils.isEmpty(comments)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"comments", (Object)comments));
        }
        return this;
    }

    public SearchIssuesParams user(String user) {
        if (!StringUtils.isEmpty(user)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"user", (Object)user));
        }
        return this;
    }

    public SearchIssuesParams repo(String repo) {
        if (!StringUtils.isEmpty(repo)) {
            this.qParameters.add((Pair<String, String>)Pair.of((Object)"repo", (Object)repo));
        }
        return this;
    }

    public SearchIssuesParams sort(Sort sort) {
        if (sort != null) {
            this.parameters.add((Pair<String, String>)Pair.of((Object)"sort", (Object)sort.getValue()));
        }
        return this;
    }

    public SearchIssuesParams order(Order order) {
        if (order != null) {
            this.parameters.add((Pair<String, String>)Pair.of((Object)"order", (Object)order.getValue()));
        }
        return this;
    }

    public String getParameters(boolean asParameter) {
        StringBuilder sb = new StringBuilder();
        if (asParameter) {
            sb.append("?");
        }
        sb.append(this.getQParameters(asParameter));
        for (Pair<String, String> parameter : this.parameters) {
            sb.append("&");
            sb.append(parameter.first()).append("=").append(parameter.second());
        }
        return sb.toString();
    }

    private String getQParameters(boolean asParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append("q=");
        if (!StringUtils.isEmpty(this.qKeyword)) {
            String kwd = this.qKeyword;
            if (asParameter) {
                kwd = kwd.replaceAll(" ", "+");
            }
            sb.append(kwd);
        }
        boolean first = true;
        for (Pair<String, String> qParameter : this.qParameters) {
            if (first) {
                if (!StringUtils.isEmpty(this.qKeyword)) {
                    sb.append("+");
                }
                first = false;
            } else {
                sb.append("+");
            }
            sb.append((String)qParameter.first()).append(":").append((String)qParameter.second());
        }
        return sb.toString();
    }

    public static enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Order valueOfString(String name) {
            for (Order value : Order.values()) {
                if (!value.getValue().equals(name)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum Sort {
        COMMENTS("comments"),
        CREATED("created"),
        UPDATED("updated");

        private final String value;

        private Sort(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Sort valueOfString(String name) {
            for (Sort value : Sort.values()) {
                if (!value.getValue().equals(name)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum Is {
        OPEN("open"),
        CLOSED("closed"),
        MERGED("merged"),
        UNMERGED("unmerged"),
        PR("pr"),
        ISSUE("issue");

        private final String value;

        private Is(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Is valueOfString(String is) {
            for (Is value : Is.values()) {
                if (!value.getValue().equals(is)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum No {
        LABEL("label"),
        MILESTONE("milestone"),
        ASSIGNEE("assignee");

        private final String value;

        private No(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static No valueOfString(String no) {
            for (No value : No.values()) {
                if (!value.getValue().equals(no)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum State {
        OPEN("open"),
        CLOSED("closed");

        private final String value;

        private State(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static State valueOfString(String state) {
            for (State value : State.values()) {
                if (!value.getValue().equals(state)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum In {
        TITLE("title"),
        BODY("body"),
        COMMENT("comment");

        private final String value;

        private In(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Type {
        PR("pr"),
        ISSUE("issue");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Type valueOfString(String type) {
            for (Type value : Type.values()) {
                if (!value.getValue().equals(type)) continue;
                return value;
            }
            return null;
        }
    }
}

