/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue;

import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;

public class GetIssuesParams {
    private Milestone milestone;
    private State state;
    private String assignee;
    private String creator;
    private String mentioned;
    private List<Label> labels;
    private Sort sort;
    private Direction direction;
    private Date since;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("YYYY-MM-ddHH:MM:SSZ");

    public GetIssuesParams milestone(Milestone milestone) {
        this.milestone = milestone;
        return this;
    }

    public GetIssuesParams assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public GetIssuesParams creator(String creator) {
        this.creator = creator;
        return this;
    }

    public GetIssuesParams mentioned(String mentioned) {
        this.mentioned = mentioned;
        return this;
    }

    public GetIssuesParams state(State state) {
        this.state = state;
        return this;
    }

    public GetIssuesParams labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public GetIssuesParams sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    public GetIssuesParams direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    public GetIssuesParams since(Date since) {
        this.since = since;
        return this;
    }

    public Map<String, String> toFilterMap() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (this.milestone != null) {
            filterMap.put("milestone", String.valueOf(this.milestone.getNumber()));
        }
        if (!StringUtils.isEmpty(this.assignee)) {
            filterMap.put("assignee", this.assignee);
        }
        if (!StringUtils.isEmpty(this.creator)) {
            filterMap.put("creator", this.creator);
        }
        if (!StringUtils.isEmpty(this.mentioned)) {
            filterMap.put("mentioned", this.mentioned);
        }
        if (this.state != null) {
            filterMap.put("state", this.state.getName());
        }
        if (this.labels != null) {
            StringBuilder sb = new StringBuilder();
            for (Label label : this.labels) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(label.getName());
            }
            String labelsWithComma = sb.toString();
            if (!StringUtils.isEmpty(labelsWithComma)) {
                filterMap.put("labels", labelsWithComma);
            }
        }
        if (this.sort != null) {
            filterMap.put("sort", this.sort.getName());
        }
        if (this.direction != null) {
            filterMap.put("direction", this.direction.getName());
        }
        if (this.since != null) {
            filterMap.put("since", DATE_FORMAT.format(this.since));
        }
        return filterMap;
    }

    public static enum Direction {
        ASC("asc"),
        DESC("desc");

        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Sort {
        CREATED("created"),
        UPDATED("updated"),
        COMMENTS("comments");

        private final String name;

        private Sort(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum State {
        OPEN("open"),
        CLOSED("closed"),
        ALL("all");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

