/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue;

import com.junichi11.netbeans.modules.github.issues.GitHubIssueState;
import com.junichi11.netbeans.modules.github.issues.GitHubIssuesConfig;
import com.junichi11.netbeans.modules.github.issues.issue.Bundle;
import com.junichi11.netbeans.modules.github.issues.issue.CreateIssueParams;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueController;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueNode;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueSupport;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.DateUtils;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.User;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;

public final class GitHubIssue {
    private final GitHubRepository repository;
    private Issue issue;
    private IssueNode node;
    private GitHubIssueController controller;
    private IssueScheduleInfo scheduleInfo;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String LABEL_NAME_ID = "github.issue.id";
    public static final String LABEL_NAME_STATUS = "github.issue.status";
    public static final String LABEL_NAME_CREATED = "github.issue.created";
    public static final String LABEL_NAME_UPDATED = "github.issue.updated";
    public static final String LABEL_NAME_CREATED_BY = "github.issue.created.by";
    public static final String LABEL_NAME_ASSIGNEE = "github.issue.assignee";
    private static final Logger LOGGER = Logger.getLogger(GitHubIssue.class.getName());

    public GitHubIssue(GitHubRepository repository) {
        this(repository, null);
    }

    public GitHubIssue(GitHubRepository repository, Issue issue) {
        this.repository = repository;
        this.issue = issue;
    }

    public GitHubRepository getRepository() {
        return this.repository;
    }

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String getDisplayName() {
        if (this.isNew()) {
            return Bundle.GitHubIssue_new_issue_displayName();
        }
        return String.format("%s - %s", this.issue.getNumber(), this.issue.getTitle());
    }

    public String getTooltip() {
        StringBuilder sb = new StringBuilder();
        String title = String.format("%s [%s]", this.getDisplayName(), this.repository.getFullName());
        sb.append("<html>");
        sb.append("<b>").append(title).append("</b>");
        sb.append("<hr>");
        Date created = this.getCreated();
        Date dueDate = this.getDueDate();
        User assignee = this.getAssignee();
        User createdUser = this.getCreatedUser();
        Milestone milestone = this.getMilestone();
        if (created != null) {
            sb.append(Bundle.GitHubIssue_LBL_created()).append(" : ").append(DateUtils.DEFAULT_DATE_FORMAT.format(created)).append("<br>");
        }
        if (dueDate != null) {
            sb.append(Bundle.GitHubIssue_LBL_dueDate()).append(" : ").append(DateUtils.DEFAULT_DATE_FORMAT.format(dueDate)).append("<br>");
        }
        if (createdUser != null) {
            sb.append(Bundle.GitHubIssue_LBL_createdBy()).append(" : ").append(createdUser.getLogin()).append("<br>");
        }
        if (assignee != null) {
            sb.append(Bundle.GitHubIssue_LBL_assignee()).append(" : ").append(assignee.getLogin()).append("<br>");
        }
        if (milestone != null) {
            sb.append(Bundle.GitHubIssue_LBL_milestone()).append(" : ").append(milestone.getTitle()).append("<br>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public IssueStatusProvider.Status getIssueStatus() {
        return GitHubIssuesConfig.getInstance().getStatus(this);
    }

    public void setIssueStatus(IssueStatusProvider.Status status) {
        GitHubIssuesConfig.getInstance().setStatus(this, status);
        this.fireStatusChange();
    }

    public boolean isNew() {
        return this.issue == null;
    }

    public String getID() {
        if (this.issue != null) {
            return String.valueOf(this.issue.getNumber());
        }
        return null;
    }

    public Collection<String> getSubtasks() {
        return Collections.emptyList();
    }

    public String getSummary() {
        if (this.issue != null) {
            return this.issue.getTitle();
        }
        return null;
    }

    public String getStatus() {
        if (this.issue != null) {
            return this.issue.getState();
        }
        return null;
    }

    public User getAssignee() {
        if (this.issue != null) {
            return this.issue.getAssignee();
        }
        return null;
    }

    public User getCreatedUser() {
        if (this.issue != null) {
            return this.issue.getUser();
        }
        return null;
    }

    public Date getUpdated() {
        if (this.issue != null) {
            return this.issue.getUpdatedAt();
        }
        return null;
    }

    public Date getCreated() {
        if (this.issue != null) {
            return this.issue.getCreatedAt();
        }
        return null;
    }

    public Date getClosed() {
        if (this.issue != null) {
            return this.issue.getClosedAt();
        }
        return null;
    }

    public Milestone getMilestone() {
        if (this.issue != null) {
            return this.issue.getMilestone();
        }
        return null;
    }

    public boolean isFinished() {
        if (this.issue == null) {
            return false;
        }
        return "closed".equals(this.issue.getState());
    }

    public boolean refresh() {
        return true;
    }

    public void refreshIssue() {
        this.getRepository().refresh(this);
        this.fireStatusChange();
    }

    public void addComment(String comment, boolean resolveAsFixed) {
        Issue i;
        if (resolveAsFixed && (i = this.getIssue()) != null) {
            GitHubIssueState state = GitHubIssueState.toEnum(i.getState());
            if (state != GitHubIssueState.OPEN) {
                LOGGER.log(Level.INFO, "This issue({0} #{1}) state is already closed.", new Object[]{i.getTitle(), i.getNumber()});
                return;
            }
            GitHubIssueSupport.toggleState(this);
        }
    }

    public void attachFile(File file, String string, boolean bln) {
    }

    public GitHubIssueController getController() {
        if (this.controller == null) {
            this.controller = new GitHubIssueController(this);
        }
        return this.controller;
    }

    public Issue submitNewIssue(CreateIssueParams params) {
        Issue newIssue = this.repository.submitNewIssue(params);
        this.setNewIssue(newIssue);
        return newIssue;
    }

    private void setNewIssue(Issue newIssue) {
        if (newIssue != null) {
            this.setIssue(newIssue);
            this.repository.addIssue(this);
            this.scheduleInfo = this.createScheduleInfo();
            this.fireChange();
            this.fireDataChange();
            this.fireScheduleChange();
            this.setIssueStatus(IssueStatusProvider.Status.SEEN);
        }
    }

    public Issue editIssue(CreateIssueParams params) {
        Issue editIssue = this.repository.editIssue(this, params);
        if (editIssue != null) {
            this.setIssue(editIssue);
            this.scheduleInfo = this.createScheduleInfo();
            this.fireChange();
            this.fireDataChange();
            this.fireScheduleChange();
        } else {
            this.repository.refresh(this);
        }
        return editIssue;
    }

    public Comment editComment(Comment comment, String editedBody) {
        if (editedBody != null) {
            String originalBody = comment.getBody();
            if (this.issue != null) {
                comment.setBody(editedBody);
                Comment editComment = GitHubIssueSupport.editComment(this.getRepository(), comment);
                if (editComment != null) {
                    String body = editComment.getBody();
                    String bodyHtml = StringUtils.markdownToHtml(body);
                    comment.setBodyHtml(String.format("<html>%s</html>", bodyHtml));
                    comment.setBody(body);
                    comment.setUpdatedAt(editComment.getUpdatedAt());
                } else {
                    comment.setBody(originalBody);
                }
                return editComment;
            }
        }
        return null;
    }

    @CheckForNull
    public PullRequest createPullRequest(String head, String base) throws IOException {
        GitHubRepository repo = this.getRepository();
        PullRequest pullRequest = repo.createPullRequest(this.getIssue().getNumber(), head, base);
        return pullRequest;
    }

    @CheckForNull
    public PullRequest createPullRequest(PullRequest pullRequest) throws IOException {
        GitHubRepository repo = this.getRepository();
        PullRequest newPullRequest = repo.createPullRequest(pullRequest);
        if (newPullRequest != null) {
            Issue newIssue = repo.getIssue(newPullRequest.getNumber());
            this.setNewIssue(newIssue);
        }
        return newPullRequest;
    }

    public boolean isCreatedUser() {
        if (this.issue == null) {
            return false;
        }
        User user = this.issue.getUser();
        return user.getLogin().equals(this.repository.getUserName());
    }

    public List<Comment> getComments() {
        if (this.isNew()) {
            return Collections.emptyList();
        }
        return this.repository.getComments(this.issue.getNumber());
    }

    public void setSchedule(IssueScheduleInfo scheduleInfo) {
        UiUtils.showPlainDialog(Bundle.GitHubIssue_MSG_setSchedule());
    }

    public Date getDueDate() {
        String status = this.getStatus();
        if (status == null || GitHubIssueState.toEnum(status) == GitHubIssueState.CLOSED) {
            return null;
        }
        Milestone milestone = this.getMilestone();
        if (milestone != null) {
            return milestone.getDueOn();
        }
        return null;
    }

    public IssueScheduleInfo getSchedule() {
        String status = this.getStatus();
        if (status == null || GitHubIssueState.toEnum(status) == GitHubIssueState.CLOSED) {
            return null;
        }
        if (this.scheduleInfo == null) {
            this.scheduleInfo = this.createScheduleInfo();
        }
        return this.scheduleInfo;
    }

    private IssueScheduleInfo createScheduleInfo() {
        Date dueDate;
        Milestone milestone = this.getMilestone();
        if (milestone != null && (dueDate = milestone.getDueOn()) != null) {
            return new IssueScheduleInfo(dueDate, 1);
        }
        return null;
    }

    public long getLastUpdatedTime() {
        Date updated = this.getUpdated();
        if (updated != null) {
            long time = updated.getTime();
            return time;
        }
        return -1L;
    }

    public static ColumnDescriptor<String>[] getColumnDescriptors() {
        LinkedList<ColumnDescriptor> descriptors = new LinkedList<ColumnDescriptor>();
        JTable table = new JTable();
        descriptors.add(new ColumnDescriptor(LABEL_NAME_ID, String.class, "ID", "ID", UIUtils.getColumnWidthInPixels((int)6, (JComponent)table)));
        descriptors.add(new ColumnDescriptor("issue.summary", String.class, Bundle.GitHubIssue_column_descriptor_summary_displayName(), Bundle.GitHubIssue_column_descriptor_summary_displayName()));
        descriptors.add(new ColumnDescriptor(LABEL_NAME_CREATED, String.class, Bundle.GitHubIssue_column_descriptor_created_displayName(), Bundle.GitHubIssue_column_descriptor_created_displayName()));
        descriptors.add(new ColumnDescriptor(LABEL_NAME_UPDATED, String.class, Bundle.GitHubIssue_column_descriptor_updated_displayName(), Bundle.GitHubIssue_column_descriptor_updated_displayName()));
        descriptors.add(new ColumnDescriptor(LABEL_NAME_CREATED_BY, String.class, Bundle.GitHubIssue_column_descriptor_createdBy_displayName(), Bundle.GitHubIssue_column_descriptor_createdBy_displayName()));
        descriptors.add(new ColumnDescriptor(LABEL_NAME_ASSIGNEE, String.class, Bundle.GitHubIssue_column_descriptor_assignee_displayName(), Bundle.GitHubIssue_column_descriptor_assignee_displayName()));
        descriptors.add(new ColumnDescriptor(LABEL_NAME_STATUS, String.class, Bundle.GitHubIssue_column_descriptor_status_displayName(), Bundle.GitHubIssue_column_descriptor_status_displayName()));
        return descriptors.toArray(new ColumnDescriptor[descriptors.size()]);
    }

    public IssueNode getIssueNode() {
        if (this.node == null) {
            this.node = this.createIssueNode();
        }
        return this.node;
    }

    public String getRecentChanges() {
        return "";
    }

    private IssueNode createIssueNode() {
        return new GitHubIssueNode(this);
    }

    public boolean isEditableUser() {
        return this.isCreatedUser() || this.repository.isCollaborator();
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    void fireChange() {
        this.propertyChangeSupport.firePropertyChange("bugtracking.changed", null, null);
    }

    void fireDataChange() {
        this.propertyChangeSupport.firePropertyChange("issue.data_changed", null, null);
    }

    void fireStatusChange() {
        this.propertyChangeSupport.firePropertyChange("issue.status_changed", null, null);
    }

    void fireScheduleChange() {
        this.propertyChangeSupport.firePropertyChange("issue.schedule_changed", null, null);
    }
}

