/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.GitHubIssues;
import com.junichi11.netbeans.modules.github.issues.issue.Bundle;
import com.junichi11.netbeans.modules.github.issues.issue.CreateIssueParams;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssueSupport;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CommentTabbedPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CreatePullRequestPanel;
import com.junichi11.netbeans.modules.github.issues.issue.ui.GitHubIssuePanel;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.RepositoryBranch;
import org.eclipse.egit.github.core.RepositoryCommitCompare;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.bugtracking.spi.IssueController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class GitHubIssueController
implements IssueController,
ChangeListener,
PropertyChangeListener {
    private GitHubIssuePanel panel;
    private String errorMessage;
    private final String repositoryId;

    public GitHubIssueController(GitHubIssue gitHubIssue) {
        this.repositoryId = gitHubIssue.getRepository().getID();
        this.getPanel().setIssue(gitHubIssue);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GitHubIssueController.this.getPanel().update();
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public JComponent getComponent() {
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void opened() {
    }

    public void closed() {
    }

    public boolean saveChanges() {
        return true;
    }

    public boolean discardUnsavedChanges() {
        return true;
    }

    public boolean isChanged() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPanel().getIssue().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPanel().getIssue().removePropertyChangeListener(listener);
    }

    private GitHubIssuePanel getPanel() {
        if (this.panel == null) {
            this.panel = new GitHubIssuePanel(this.repositoryId);
            this.panel.addChangeListener(this);
            this.panel.addAction(this.getSubmitIssueAction());
            this.panel.addAction(this.getCommentAction());
            this.panel.addAction(this.getCloseReopenAction());
            this.panel.addAction(this.getCreatePullRequestAction());
            this.panel.addCommentsChangeListener(this);
        }
        return this.panel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.validate();
    }

    private void validate() {
        if (!this.isValid()) {
            this.getPanel().setErrorMessage(this.errorMessage);
        } else {
            this.getPanel().setErrorMessage("");
        }
    }

    private boolean isValid() {
        String title = this.getPanel().getTitle();
        if (StringUtils.isEmpty(title)) {
            this.errorMessage = Bundle.GitHubIssueController_message_empty_title();
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    private SubmitIssueAction getSubmitIssueAction() {
        return new SubmitIssueAction();
    }

    private CommentAction getCommentAction() {
        return new CommentAction();
    }

    private CloseReopenAction getCloseReopenAction() {
        return new CloseReopenAction();
    }

    private CreatePullRequestAction getCreatePullRequestAction() {
        return new CreatePullRequestAction();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "github.issues.comment.quote": {
                this.quoteComment();
                break;
            }
            case "github.issues.comment.edited": {
                this.editComment();
                break;
            }
            case "github.issues.comment.deleted": {
                this.deleteComment();
                break;
            }
        }
    }

    private void quoteComment() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GitHubIssuePanel p = GitHubIssueController.this.getPanel();
                String quoteComment = StringUtils.toQuoteComment(p.getQuoteComment()) + "\n";
                p.appendNewComment(quoteComment);
            }
        });
    }

    private void editComment() {
        GitHubIssue issue;
        final Comment comment = this.getPanel().getEditedComment();
        final String editedBody = CommentTabbedPanel.showDialog(Bundle.GitHubIssueController_edit_comment_title(), comment.getBody());
        if (editedBody != null && (issue = this.getPanel().getIssue()) != null) {
            RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
            rp.post(new Runnable(){

                @Override
                public void run() {
                    Comment editedComment = issue.editComment(comment, editedBody);
                    if (editedComment == null) {
                        UiUtils.showErrorDialog(Bundle.GitHubIssueController_edit_comment_fail());
                        return;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitHubIssueController.this.getPanel().loadComments();
                        }
                    });
                }
            });
        }
    }

    private void deleteComment() {
        final Comment deletedComment = this.getPanel().getDeletedComment();
        if (deletedComment == null) {
            return;
        }
        RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                GitHubRepository repository = GitHubIssueController.this.getPanel().getIssue().getRepository();
                final boolean success = GitHubIssueSupport.deleteComment(repository, deletedComment);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (success) {
                            GitHubIssueController.this.getPanel().removeDeletedComment();
                        } else {
                            UiUtils.showErrorDialog(Bundle.GitHubIssueController_delete_comment_fail());
                        }
                    }
                });
            }
        });
    }

    static class ComparePullRequestPropertyChangeListener
    implements PropertyChangeListener {
        private final GitHubRepository repository;
        private final CreatePullRequestPanel panel;
        private final NotifyDescriptor descriptor;
        private String errorMessage;
        private RepositoryCommitCompare compare;

        public ComparePullRequestPropertyChangeListener(GitHubRepository repository, CreatePullRequestPanel createPullRequestPanel, NotifyDescriptor descriptor) {
            this.repository = repository;
            this.panel = createPullRequestPanel;
            this.descriptor = descriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt != null && !evt.getPropertyName().equals("github.issues.pull.request.compare")) {
                return;
            }
            this.errorMessage = null;
            this.compare = null;
            this.panel.setCompareButtonEnabled(false);
            try {
                String status;
                RepositoryBranch baseBranch = this.panel.getSelectedBaseBranch();
                RepositoryBranch headBranch = this.panel.getSelectedHeadBranch();
                if (baseBranch.getCommit().getSha().equals(headBranch.getCommit().getSha())) {
                    this.panel.setErrorMessage(Bundle.ComparePullRequestPropertyChangeListener_message_no_compare());
                    this.descriptor.setValid(false);
                }
                this.compare();
                if (this.compare == null) {
                    this.panel.setErrorMessage(this.errorMessage);
                    this.descriptor.setValid(false);
                    return;
                }
                switch (status = this.compare.getStatus()) {
                    case "identical": 
                    case "behind": {
                        this.panel.setErrorMessage(Bundle.ComparePullRequestPropertyChangeListener_message_no_compare());
                        this.descriptor.setValid(false);
                        return;
                    }
                    case "diverged": {
                        this.panel.setErrorMessage(Bundle.ComparePullRequestPropertyChangeListener_message_conflict());
                        this.descriptor.setValid(true);
                        return;
                    }
                    case "ahead": {
                        break;
                    }
                }
                this.panel.setErrorMessage("");
                this.descriptor.setValid(true);
            }
            finally {
                this.panel.setCompareButtonEnabled(true);
            }
        }

        private void compare() {
            Repository headRepo = this.panel.getSelectedHeadRepository();
            final User owner = headRepo.getOwner();
            BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        compare = repository.compare(panel.getSelectedBaseBranch().getName(), owner.getLogin() + ":" + panel.getSelectedHeadBranch().getName());
                    }
                    catch (IOException ex) {
                        errorMessage = ex.getMessage();
                    }
                }
            }, (String)"Comparing...", (AtomicBoolean)new AtomicBoolean(), (boolean)false);
        }
    }

    public class CreatePullRequestAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            final boolean isNewPullRequest = actionCommand.equals("New PR");
            GitHubIssuePanel p = GitHubIssueController.this.getPanel();
            p.setCreatePullRequestButtonEnabled(false);
            final GitHubIssue issue = p.getIssue();
            if (isNewPullRequest && !p.isNewPullRequestSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GitHubIssueController.this.getPanel().setNewPullRequest(null);
                    }
                });
                return;
            }
            RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
            rp.post(new Runnable(){

                @Override
                public void run() {
                    final GitHubRepository repository = issue.getRepository();
                    GitHubCache cache = GitHubCache.create(repository);
                    final User mySelf = cache.getMySelf();
                    List<RepositoryBranch> baseBranches = cache.getBranches(true);
                    final HashMap<Repository, List<RepositoryBranch>> baseRepositories = new HashMap<Repository, List<RepositoryBranch>>();
                    baseRepositories.put(repository.getRepository(), baseBranches);
                    final Map headRepositories = CreatePullRequestAction.this.getHeadRepositories(repository, baseBranches);
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                if (baseRepositories.isEmpty() || headRepositories.isEmpty()) {
                                    UiUtils.showErrorDialog(Bundle.CreatePullRequestAction_error_message_cannot_find_base_head_repositories());
                                    return;
                                }
                                final CreatePullRequestPanel createPullRequestPanel = new CreatePullRequestPanel(baseRepositories, headRepositories);
                                createPullRequestPanel.setMessage(Bundle.CreatePullRequestAction_confirmation_message());
                                final NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)createPullRequestPanel, Bundle.CreatePullRequestAction_descriptor_title(), 2, 3);
                                ChangeListener changeListener = new ChangeListener(){

                                    @Override
                                    public void stateChanged(ChangeEvent e) {
                                        descriptor.setValid(false);
                                        createPullRequestPanel.setErrorMessage("");
                                    }
                                };
                                createPullRequestPanel.addChangeListener(changeListener);
                                ComparePullRequestPropertyChangeListener propertyChangeListener = new ComparePullRequestPropertyChangeListener(repository, createPullRequestPanel, (NotifyDescriptor)descriptor);
                                createPullRequestPanel.addPropertyChangeListener(propertyChangeListener);
                                changeListener.stateChanged(null);
                                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
                                    RepositoryBranch selectedBaseBranch = createPullRequestPanel.getSelectedBaseBranch();
                                    RepositoryBranch selectedHeadBranch = createPullRequestPanel.getSelectedHeadBranch();
                                    String baseBranch = selectedBaseBranch.getName();
                                    String headBranch = mySelf.getLogin() + ":" + selectedHeadBranch.getName();
                                    try {
                                        if (isNewPullRequest) {
                                            PullRequestMarker baseMarker = new PullRequestMarker();
                                            baseMarker.setLabel(baseBranch);
                                            PullRequestMarker headMarker = new PullRequestMarker();
                                            headMarker.setLabel(headBranch);
                                            PullRequest newPullRequest = new PullRequest().setBase(baseMarker).setHead(headMarker);
                                            GitHubIssueController.this.getPanel().setNewPullRequest(newPullRequest);
                                        } else {
                                            PullRequest pullRequest = issue.createPullRequest(headBranch, baseBranch);
                                            if (pullRequest != null) {
                                                GitHubIssueController.this.getPanel().refresh();
                                            }
                                        }
                                    }
                                    catch (IOException ex) {
                                        UiUtils.showErrorDialog("Can't create a pull request:" + ex.getMessage());
                                    }
                                } else if (isNewPullRequest) {
                                    GitHubIssueController.this.getPanel().setNewPullRequestSelected(false);
                                }
                                createPullRequestPanel.removeChangeListener(changeListener);
                                createPullRequestPanel.removePropertyChangeListener(propertyChangeListener);
                            }
                            finally {
                                GitHubIssueController.this.getPanel().setCreatePullRequestButtonEnabled(true);
                            }
                        }
                    });
                }
            });
        }

        private Map<Repository, List<RepositoryBranch>> getHeadRepositories(GitHubRepository repository, List<RepositoryBranch> baseBranches) {
            HashMap<Repository, List<RepositoryBranch>> myRepositories = new HashMap<Repository, List<RepositoryBranch>>();
            GitHubCache cache = GitHubCache.create(repository);
            User mySelf = cache.getMySelf();
            String repositoryAuthor = repository.getRepositoryAuthor();
            if (repositoryAuthor.equals(mySelf.getLogin())) {
                myRepositories.put(repository.getRepository(), baseBranches);
            } else {
                if (repository.isCollaborator()) {
                    myRepositories.put(repository.getRepository(), baseBranches);
                }
                List<Repository> forks = cache.getForks();
                Repository myRepository = null;
                for (Repository fork : forks) {
                    User owner = fork.getOwner();
                    if (!owner.getLogin().equals(mySelf.getLogin())) continue;
                    myRepository = fork;
                    break;
                }
                if (myRepository == null) {
                    return Collections.emptyMap();
                }
                GitHubClient client = repository.createGitHubClient();
                List<RepositoryBranch> myRepositoryBranches = this.getMyRepositoryBranches(client, myRepository);
                myRepositories.put(myRepository, myRepositoryBranches);
            }
            return myRepositories;
        }

        private List<RepositoryBranch> getMyRepositoryBranches(GitHubClient client, Repository myRepository) {
            RepositoryService service = new RepositoryService(client);
            try {
                return service.getBranches((IRepositoryIdProvider)myRepository);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return Collections.emptyList();
            }
        }
    }

    public class CloseReopenAction
    extends CommentAction {
        private CloseReopenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final GitHubIssuePanel p = GitHubIssueController.this.getPanel();
            p.setNewCommentEnabled(false);
            GitHubIssues gitHubIssues = GitHubIssues.getInstance();
            RequestProcessor rp = gitHubIssues.getRequestProcessor();
            rp.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        String comment = p.getNewComment();
                        if (StringUtils.isEmpty(comment)) {
                            CloseReopenAction.this.closeReopen();
                        } else {
                            Comment newComment = CloseReopenAction.this.comment(comment);
                            if (newComment != null) {
                                CloseReopenAction.this.closeReopen();
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                p.update();
                            }
                        });
                    }
                    finally {
                        p.setNewCommentEnabled(true);
                    }
                }
            });
        }

        private boolean closeReopen() {
            return GitHubIssueSupport.toggleState(GitHubIssueController.this.getPanel().getIssue());
        }
    }

    public class CommentAction
    implements ActionListener {
        private CommentAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final GitHubIssuePanel p = GitHubIssueController.this.getPanel();
            GitHubIssues gitHubIssues = GitHubIssues.getInstance();
            RequestProcessor rp = gitHubIssues.getRequestProcessor();
            p.setNewCommentEnabled(false);
            rp.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String comment = p.getNewComment();
                                if (StringUtils.isEmpty(comment)) {
                                    return;
                                }
                                CommentAction.this.comment(comment);
                                p.update();
                            }
                            finally {
                                p.setNewCommentEnabled(true);
                            }
                        }
                    });
                }
            });
        }

        protected Comment comment(String comment) {
            GitHubIssuePanel p = GitHubIssueController.this.getPanel();
            if (StringUtils.isEmpty(comment)) {
                return null;
            }
            Comment newComment = GitHubIssueSupport.comment(p.getIssue(), comment);
            if (newComment != null) {
                p.setNewComment("");
                StatusDisplayer.getDefault().setStatusText(Bundle.CommentAction_message_comment_added());
            } else {
                UiUtils.showErrorDialog(Bundle.CommentAction_message_comment_added_fail());
            }
            return newComment;
        }
    }

    public class SubmitIssueAction
    implements ActionListener {
        private SubmitIssueAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final GitHubIssuePanel p = GitHubIssueController.this.getPanel();
            p.setSubmitButtonEnabled(false);
            RequestProcessor rp = GitHubIssues.getInstance().getRequestProcessor();
            rp.post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            block12: {
                                GitHubIssue issue = p.getIssue();
                                CreateIssueParams issueParams = SubmitIssueAction.this.getCreateIssueParams(issue.isNew(), p);
                                if (issue.isNew()) {
                                    if (p.isNewPullRequestSelected()) {
                                        PullRequest newPullRequest = p.getNewPullRequest();
                                        if (newPullRequest != null) {
                                            newPullRequest.setTitle(issueParams.getTitle()).setBody(issueParams.getBody());
                                            try {
                                                PullRequest createdPullRequest = issue.createPullRequest(newPullRequest);
                                                if (createdPullRequest != null) {
                                                    issue.editIssue(issueParams);
                                                    p.update();
                                                    break block12;
                                                }
                                                UiUtils.showErrorDialog(Bundle.SubmitIssueAction_message_pull_request_added_fail());
                                            }
                                            catch (IOException ex) {
                                                UiUtils.showErrorDialog(ex.getMessage());
                                            }
                                        }
                                    } else {
                                        Issue newIssue = issue.submitNewIssue(issueParams);
                                        if (newIssue != null) {
                                            p.update();
                                        } else {
                                            UiUtils.showErrorDialog(Bundle.SubmitIssueAction_message_issue_added_fail());
                                        }
                                    }
                                } else {
                                    Issue editIssue = issue.editIssue(issueParams);
                                    if (editIssue != null) {
                                        p.update();
                                    } else {
                                        UiUtils.showErrorDialog(Bundle.SubmitIssueAction_message_issue_updated_fail());
                                    }
                                }
                            }
                            p.setSubmitButtonEnabled(true);
                        }
                    });
                }
            });
        }

        private CreateIssueParams getCreateIssueParams(boolean isNew, GitHubIssuePanel p) {
            Milestone milestone;
            User assignee = p.getAssignee();
            if (!isNew && assignee == null) {
                assignee = new User();
                assignee.setLogin("");
            }
            if ((milestone = p.getMilestone()) == null) {
                milestone = new Milestone();
            }
            CreateIssueParams createIssueParams = new CreateIssueParams(p.getTitle()).body(p.getDescription()).milestone(milestone).labels(p.getLabels());
            if (assignee != null) {
                createIssueParams = createIssueParams.assignee(assignee);
            }
            return createIssueParams;
        }
    }
}

