/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue;

import com.junichi11.netbeans.modules.github.issues.GitHubIcons;
import com.junichi11.netbeans.modules.github.issues.GitHubIssueState;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.utils.GitHubIssuesUtils;
import java.awt.Image;
import java.util.ArrayList;
import org.eclipse.egit.github.core.Issue;
import org.netbeans.modules.bugtracking.spi.IssuePriorityInfo;
import org.netbeans.modules.bugtracking.spi.IssuePriorityProvider;

public class GitHubIssuePriorityProvider
implements IssuePriorityProvider<GitHubIssue> {
    public String getPriorityID(GitHubIssue githubIssue) {
        Issue issue = githubIssue.getIssue();
        if (issue == null) {
            return "";
        }
        GitHubIssuePriority priority = GitHubIssuePriority.None;
        GitHubIssueState state = GitHubIssueState.toEnum(issue.getState());
        boolean isPullRequest = GitHubIssuesUtils.isPullRequest(issue);
        switch (state) {
            case CLOSED: {
                if (isPullRequest) {
                    priority = GitHubIssuePriority.ClosedPullRequest;
                    break;
                }
                priority = GitHubIssuePriority.Closed;
                break;
            }
            case OPEN: {
                priority = isPullRequest ? GitHubIssuePriority.OpenPullRequest : GitHubIssuePriority.Open;
            }
        }
        return priority.getId();
    }

    public IssuePriorityInfo[] getPriorityInfos() {
        ArrayList<IssuePriorityInfo> info = new ArrayList<IssuePriorityInfo>();
        for (GitHubIssuePriority priority : GitHubIssuePriority.values()) {
            Image image = priority.getImage();
            if (image != null) {
                info.add(new IssuePriorityInfo(priority.getId(), priority.getState(), image));
                continue;
            }
            info.add(new IssuePriorityInfo(priority.getId(), priority.getState()));
        }
        return info.toArray(new IssuePriorityInfo[info.size()]);
    }

    public static enum GitHubIssuePriority {
        Open("open", "Open", GitHubIcons.OPEN_ISSUE_IMAGE_16),
        Closed("closed", "Closed", GitHubIcons.CLOSED_ISSUE_IMAGE_16),
        OpenPullRequest("open.pull.request", "Open", GitHubIcons.OPEN_PULL_REQUEST_IMAGE_16),
        ClosedPullRequest("closed.pull.request", "Closed", GitHubIcons.CLOSED_PULL_REQUEST_IMAGE_16),
        MergedPullRequest("merged.pull.request", "Merged", GitHubIcons.MERGED_PULL_REQUEST_IMAGE_16),
        None("", "", null);

        private final String id;
        private final String state;
        private final Image image;

        private GitHubIssuePriority(String id, String state, Image image) {
            this.id = id;
            this.state = state;
            this.image = image;
        }

        public String getId() {
            return this.id;
        }

        public String getState() {
            return this.state;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

