/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue;

import com.junichi11.netbeans.modules.github.issues.GitHubIssueState;
import com.junichi11.netbeans.modules.github.issues.issue.GitHubIssue;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;

public final class GitHubIssueSupport {
    private static final Logger LOGGER = Logger.getLogger(GitHubIssueSupport.class.getName());

    private GitHubIssueSupport() {
    }

    public static boolean toggleState(GitHubIssue gitHubIssue) {
        if (gitHubIssue == null) {
            return false;
        }
        Issue issue = gitHubIssue.getIssue();
        if (issue == null) {
            return false;
        }
        GitHubIssueState state = GitHubIssueState.toEnum(issue.getState());
        try {
            GitHubRepository repository = gitHubIssue.getRepository();
            IssueService issueService = GitHubIssueSupport.createIssueService(repository);
            if (issueService != null) {
                switch (state) {
                    case CLOSED: {
                        issue.setState(GitHubIssueState.OPEN.toString());
                        break;
                    }
                    case OPEN: {
                        issue.setState(GitHubIssueState.CLOSED.toString());
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                Issue editedIssue = issueService.editIssue((IRepositoryIdProvider)repository.getRepository(), issue);
                if (editedIssue != null) {
                    gitHubIssue.setIssue(editedIssue);
                    StatusDisplayer.getDefault().setStatusText("Status has been changed.");
                    gitHubIssue.fireDataChange();
                    return true;
                }
            }
        }
        catch (IOException ex) {
            issue.setState(state.toString());
            LOGGER.log(Level.WARNING, ex.getMessage());
            UiUtils.showErrorDialog("Can''t change issue status.");
        }
        return false;
    }

    public static Comment comment(GitHubIssue gitHubIssue, String comment) {
        if (StringUtils.isEmpty(comment)) {
            return null;
        }
        Issue issue = gitHubIssue.getIssue();
        if (issue != null) {
            try {
                GitHubRepository gitHubRepository = gitHubIssue.getRepository();
                Comment createdComment = GitHubIssueSupport.createComment(gitHubRepository, issue, comment);
                if (createdComment != null) {
                    return createdComment;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage());
            }
        }
        return null;
    }

    private static Comment createComment(GitHubRepository gitHubRepository, Issue issue, String comment) throws IOException {
        IssueService issueService = GitHubIssueSupport.createIssueService(gitHubRepository);
        if (issueService == null) {
            return null;
        }
        return issueService.createComment((IRepositoryIdProvider)gitHubRepository.getRepository(), issue.getNumber(), comment);
    }

    @CheckForNull
    public static Comment editComment(GitHubRepository repository, Comment comment) {
        IssueService issueService = GitHubIssueSupport.createIssueService(repository);
        if (issueService == null) {
            return null;
        }
        try {
            return issueService.editComment((IRepositoryIdProvider)repository.getRepository(), comment);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage());
            return null;
        }
    }

    public static boolean deleteComment(GitHubRepository repository, Comment comment) {
        IssueService issueService = GitHubIssueSupport.createIssueService(repository);
        if (issueService == null) {
            return false;
        }
        boolean success = true;
        try {
            issueService.deleteComment((IRepositoryIdProvider)repository.getRepository(), comment.getId());
        }
        catch (IOException ex) {
            success = false;
            LOGGER.log(Level.WARNING, ex.getMessage());
        }
        return success;
    }

    public static void showInBrowser(GitHubIssue gitHubIssue) {
        if (!gitHubIssue.isNew()) {
            Issue issue = gitHubIssue.getIssue();
            String htmlUrl = issue.getHtmlUrl();
            try {
                URL url = new URL(htmlUrl);
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.WARNING, "Can''t open the browser : {0}", ex.getMessage());
            }
        }
    }

    @CheckForNull
    private static IssueService createIssueService(GitHubRepository gitHubRepository) {
        GitHubClient client = gitHubRepository.createGitHubClient();
        if (client == null) {
            return null;
        }
        return new IssueService(client);
    }
}

