/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.DateUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.User;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttributesViewPanel
extends JPanel {
    private static final long serialVersionUID = 8704520155275718422L;
    private JLabel assigneeLabel;
    private JLabel assigneeNameLabel;
    private JLabel labelsLabel;
    private JPanel labelsPanel;
    private JLabel milestoneLabel;
    private JLabel milestoneNameLabel;

    public AttributesViewPanel() {
        this.initComponents();
        Font assigneeFont = this.assigneeNameLabel.getFont();
        Font bold = new Font(assigneeFont.getName(), 1, assigneeFont.getSize());
        this.assigneeNameLabel.setFont(bold);
        this.milestoneNameLabel.setFont(bold);
    }

    public void setAttributes(Issue issue, GitHubRepository repository) {
        Milestone milestone;
        this.initAttributes();
        if (issue == null) {
            return;
        }
        User assignee = issue.getAssignee();
        if (assignee != null) {
            String login = assignee.getLogin();
            this.assigneeNameLabel.setText(login);
            this.assigneeNameLabel.setToolTipText(login);
            if (repository != null) {
                GitHubCache cache = GitHubCache.create(repository);
                this.assigneeNameLabel.setIcon(cache.getUserIcon(assignee));
            }
        }
        if ((milestone = issue.getMilestone()) != null) {
            this.milestoneNameLabel.setText(milestone.getTitle());
            Date dueDate = milestone.getDueOn();
            String description = milestone.getDescription();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            if (description == null) {
                description = "";
            }
            description = description.replaceAll("\n", "<br>");
            if (dueDate != null) {
                sb.append(Bundle.AttributesViewPanel_LBL_dueDate()).append(" : ").append(DateUtils.DEFAULT_DATE_FORMAT.format(dueDate)).append("<br>");
                sb.append("<hr>");
            }
            sb.append(description);
            sb.append("</html>");
            this.milestoneNameLabel.setToolTipText(sb.toString());
        }
        List labels = issue.getLabels();
        for (Label label : labels) {
            String name = label.getName();
            JLabel l = new JLabel(String.format("<html><b>%s</b></html>", name));
            l.setToolTipText(name);
            l.setOpaque(true);
            Color bgColor = Color.decode(String.format("#%s", label.getColor()));
            l.setBackground(bgColor);
            l.setForeground(AttributesViewPanel.getForeground(bgColor));
            EmptyBorder emptyBorder = new EmptyBorder(3, 5, 3, 5);
            l.setBorder(emptyBorder);
            this.labelsPanel.add(l);
        }
    }

    private void initAttributes() {
        this.assigneeNameLabel.setText("-");
        this.milestoneNameLabel.setText("-");
        this.labelsPanel.removeAll();
    }

    private static int getBrightness(Color color) {
        return (color.getRed() * 299 + color.getGreen() * 578 + color.getBlue() * 114) / 1000;
    }

    private static Color getForeground(Color bgColor) {
        int brightness = AttributesViewPanel.getBrightness(bgColor);
        return brightness < 130 ? Color.WHITE : Color.BLACK;
    }

    private void initComponents() {
        this.assigneeLabel = new JLabel();
        this.assigneeNameLabel = new JLabel();
        this.milestoneLabel = new JLabel();
        this.milestoneNameLabel = new JLabel();
        this.labelsLabel = new JLabel();
        this.labelsPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.assigneeLabel, (String)NbBundle.getMessage(AttributesViewPanel.class, (String)"AttributesViewPanel.assigneeLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.assigneeNameLabel, (String)NbBundle.getMessage(AttributesViewPanel.class, (String)"AttributesViewPanel.assigneeNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.milestoneLabel, (String)NbBundle.getMessage(AttributesViewPanel.class, (String)"AttributesViewPanel.milestoneLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.milestoneNameLabel, (String)NbBundle.getMessage(AttributesViewPanel.class, (String)"AttributesViewPanel.milestoneNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.labelsLabel, (String)NbBundle.getMessage(AttributesViewPanel.class, (String)"AttributesViewPanel.labelsLabel.text"));
        this.labelsPanel.setLayout(new GridLayout(0, 5, 2, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.assigneeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assigneeNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.milestoneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.milestoneNameLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.labelsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelsPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.assigneeLabel).addComponent(this.assigneeNameLabel).addComponent(this.milestoneLabel).addComponent(this.milestoneNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelsLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.labelsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }
}

