/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.issue.ui.Bundle;
import com.junichi11.netbeans.modules.github.issues.utils.DateUtils;
import com.junichi11.netbeans.modules.github.issues.utils.UiUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.eclipse.egit.github.core.Comment;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CommentPanel
extends JPanel {
    private static final long serialVersionUID = -1191208334240462498L;
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String PLAIN_MIME_TYPE = "text/plain";
    private Comment comment;
    private boolean isQuote;
    private boolean isEdited;
    private boolean isDeleted;
    private JTextPane contentTextPane;
    private JLabel createdDateLabel;
    private JLabel createdLabel;
    private LinkButton deleteLinkButton;
    private LinkButton editLinkButton;
    private JSeparator jSeparator1;
    private LinkButton previewLinkButton;
    private LinkButton quoteLinkButton;
    private JLabel updatedDateLabel;
    private JLabel updatedLabel;
    private LinkButton userLinkButton;

    private CommentPanel() {
        this.initComponents();
    }

    public CommentPanel(Comment comment, Icon icon) {
        this.comment = comment;
        this.initComponents();
        this.init();
        this.load(icon);
    }

    private void init() {
        Font contentFont = this.contentTextPane.getFont();
        this.contentTextPane.setFont(new Font("Monospaced", contentFont.getStyle(), contentFont.getSize()));
        this.previewLinkButton.setText(Bundle.CommentPanel_previewLinkButton_title_html());
    }

    final void load(Icon icon) {
        if (this.comment != null) {
            this.setUserName(this.comment.getUser().getLogin());
            this.setUserIcon(icon);
            this.setCreatedDate(this.comment.getCreatedAt());
            this.setUpdatedDate(this.comment.getUpdatedAt());
            this.setContent(this.comment.getBody());
        }
    }

    private void setUserName(String name) {
        this.userLinkButton.setText(name);
    }

    private void setUserIcon(Icon icon) {
        this.userLinkButton.setIcon(icon);
    }

    private void setCreatedDate(Date date) {
        if (date != null) {
            this.createdDateLabel.setText(DateUtils.DEFAULT_DATE_TIME_FORMAT.format(date));
        }
    }

    private void setUpdatedDate(Date date) {
        if (date != null) {
            this.updatedDateLabel.setText(DateUtils.DEFAULT_DATE_TIME_FORMAT.format(date));
        }
    }

    private void setContent(String content) {
        if (content == null) {
            this.contentTextPane.setText("");
        } else if (content.isEmpty()) {
            this.contentTextPane.setText("");
        } else {
            this.contentTextPane.setText(content);
        }
    }

    public Comment getComment() {
        return this.comment;
    }

    public String getSelectedText() {
        return this.contentTextPane.getSelectedText();
    }

    public boolean isQuote() {
        return this.isQuote;
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setQuoteEnabled(boolean isEnabled) {
        this.quoteLinkButton.setEnabled(isEnabled);
    }

    public void setEditEnabled(boolean isEnabled) {
        this.editLinkButton.setEnabled(isEnabled);
    }

    public void setDeleteEnabled(boolean isEnabled) {
        this.deleteLinkButton.setEnabled(isEnabled);
    }

    void resetProperties() {
        this.isQuote = false;
        this.isEdited = false;
        this.isDeleted = false;
    }

    private void initComponents() {
        this.createdLabel = new JLabel();
        this.createdDateLabel = new JLabel();
        this.updatedLabel = new JLabel();
        this.updatedDateLabel = new JLabel();
        this.userLinkButton = new LinkButton();
        this.editLinkButton = new LinkButton();
        this.jSeparator1 = new JSeparator();
        this.contentTextPane = new JTextPane();
        this.quoteLinkButton = new LinkButton();
        this.deleteLinkButton = new LinkButton();
        this.previewLinkButton = new LinkButton();
        Mnemonics.setLocalizedText((JLabel)this.createdLabel, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.createdLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.createdDateLabel, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.createdDateLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.updatedLabel, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.updatedLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.updatedDateLabel, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.updatedDateLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.userLinkButton, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.userLinkButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.editLinkButton, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.editLinkButton.text"));
        this.editLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommentPanel.this.editLinkButtonActionPerformed(evt);
            }
        });
        this.contentTextPane.setEditable(false);
        this.contentTextPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        Mnemonics.setLocalizedText((AbstractButton)this.quoteLinkButton, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.quoteLinkButton.text"));
        this.quoteLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommentPanel.this.quoteLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteLinkButton, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.deleteLinkButton.text"));
        this.deleteLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommentPanel.this.deleteLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.previewLinkButton, (String)NbBundle.getMessage(CommentPanel.class, (String)"CommentPanel.previewLinkButton.text"));
        this.previewLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommentPanel.this.previewLinkButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.contentTextPane).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent((Component)this.userLinkButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addComponent(this.createdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createdDateLabel).addGap(18, 18, 18).addComponent(this.updatedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updatedDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.previewLinkButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.quoteLinkButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.editLinkButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.deleteLinkButton, -2, -1, -2)).addComponent(this.jSeparator1, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdLabel).addComponent(this.createdDateLabel).addComponent(this.updatedLabel).addComponent(this.updatedDateLabel).addComponent((Component)this.userLinkButton, -2, -1, -2).addComponent((Component)this.editLinkButton, -2, -1, -2).addComponent((Component)this.quoteLinkButton, -2, -1, -2).addComponent((Component)this.deleteLinkButton, -2, -1, -2).addComponent((Component)this.previewLinkButton, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contentTextPane, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void quoteLinkButtonActionPerformed(ActionEvent evt) {
        this.isQuote = true;
        this.firePropertyChange("github.issues.comment.quote", null, null);
    }

    private void deleteLinkButtonActionPerformed(ActionEvent evt) {
        if (!UiUtils.showQuestionDialog(Bundle.CommentPanel_message_delete_issue())) {
            return;
        }
        this.isDeleted = true;
        this.firePropertyChange("github.issues.comment.deleted", null, null);
    }

    private void editLinkButtonActionPerformed(ActionEvent evt) {
        this.isEdited = true;
        this.firePropertyChange("github.issues.comment.edited", null, null);
    }

    private void previewLinkButtonActionPerformed(ActionEvent evt) {
        String text = this.previewLinkButton.getText();
        if (text.equals(Bundle.CommentPanel_previewLinkButton_title_html())) {
            this.previewLinkButton.setText(Bundle.CommentPanel_previewLinkButton_title_plain());
        } else {
            this.previewLinkButton.setText(Bundle.CommentPanel_previewLinkButton_title_html());
        }
        String contentType = this.contentTextPane.getContentType();
        if (contentType.equals(HTML_MIME_TYPE)) {
            this.contentTextPane.setContentType(PLAIN_MIME_TYPE);
            this.contentTextPane.setText(this.comment.getBody());
            return;
        }
        this.contentTextPane.setContentType(HTML_MIME_TYPE);
        this.contentTextPane.setText(this.comment.getBodyHtml());
    }
}

