/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class CommentTabbedPanel
extends JPanel {
    private static final long serialVersionUID = -231725010987636355L;
    private JEditorPane commentPreviewEditorPane;
    private JPanel commentPreviewPanel;
    private JScrollPane commentPreviewScrollPane;
    private JTabbedPane commentTabbedPane;
    private JPanel commentWritePanel;
    private JScrollPane commentWriteScrollPane;
    private JTextArea commentWriteTextArea;

    public CommentTabbedPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        Font commentFont = this.commentWriteTextArea.getFont();
        this.commentWriteTextArea.setFont(new Font("Monospaced", commentFont.getStyle(), commentFont.getSize()));
    }

    public String getText() {
        return this.commentWriteTextArea.getText();
    }

    public void setText(String text) {
        this.commentWriteTextArea.setText(text);
    }

    public void appendText(String text) {
        StringBuilder sb = new StringBuilder();
        String comment = this.commentWriteTextArea.getText();
        sb.append(comment);
        sb.append(text);
        this.commentWriteTextArea.setText(sb.toString());
    }

    public void setEditable(boolean isEditable) {
        this.commentWriteTextArea.setEditable(isEditable);
    }

    public static String showDialog(String title, String text) {
        CommentTabbedPanel panel = new CommentTabbedPanel();
        panel.setText(text);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title, true, 2, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return panel.getText();
        }
        return null;
    }

    private void initComponents() {
        this.commentTabbedPane = new JTabbedPane();
        this.commentWritePanel = new JPanel();
        this.commentWriteScrollPane = new JScrollPane();
        this.commentWriteTextArea = new JTextArea();
        this.commentPreviewPanel = new JPanel();
        this.commentPreviewScrollPane = new JScrollPane();
        this.commentPreviewEditorPane = new JEditorPane();
        this.commentTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CommentTabbedPanel.this.commentTabbedPaneStateChanged(evt);
            }
        });
        this.commentWriteTextArea.setColumns(20);
        this.commentWriteTextArea.setRows(5);
        this.commentWriteScrollPane.setViewportView(this.commentWriteTextArea);
        GroupLayout commentWritePanelLayout = new GroupLayout(this.commentWritePanel);
        this.commentWritePanel.setLayout(commentWritePanelLayout);
        commentWritePanelLayout.setHorizontalGroup(commentWritePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentWriteScrollPane, -1, 392, Short.MAX_VALUE));
        commentWritePanelLayout.setVerticalGroup(commentWritePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentWriteScrollPane, -1, 263, Short.MAX_VALUE));
        this.commentTabbedPane.addTab(NbBundle.getMessage(CommentTabbedPanel.class, (String)"CommentTabbedPanel.commentWritePanel.TabConstraints.tabTitle"), this.commentWritePanel);
        this.commentPreviewEditorPane.setEditable(false);
        this.commentPreviewEditorPane.setContentType("text/html");
        this.commentPreviewScrollPane.setViewportView(this.commentPreviewEditorPane);
        GroupLayout commentPreviewPanelLayout = new GroupLayout(this.commentPreviewPanel);
        this.commentPreviewPanel.setLayout(commentPreviewPanelLayout);
        commentPreviewPanelLayout.setHorizontalGroup(commentPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentPreviewScrollPane, -1, 392, Short.MAX_VALUE));
        commentPreviewPanelLayout.setVerticalGroup(commentPreviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentPreviewScrollPane, -1, 263, Short.MAX_VALUE));
        this.commentTabbedPane.addTab(NbBundle.getMessage(CommentTabbedPanel.class, (String)"CommentTabbedPanel.commentPreviewPanel.TabConstraints.tabTitle"), this.commentPreviewPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentTabbedPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.commentTabbedPane));
    }

    private void commentTabbedPaneStateChanged(ChangeEvent evt) {
        Component selectedComponent = this.commentTabbedPane.getSelectedComponent();
        if (selectedComponent == this.commentPreviewPanel) {
            String html = StringUtils.markdownToHtml(this.commentWriteTextArea.getText());
            this.commentPreviewEditorPane.setText(html);
        }
    }
}

