/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import com.junichi11.netbeans.modules.github.issues.GitHubCache;
import com.junichi11.netbeans.modules.github.issues.issue.ui.CommentPanel;
import com.junichi11.netbeans.modules.github.issues.repository.GitHubRepository;
import com.junichi11.netbeans.modules.github.issues.utils.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.User;

public class CommentsPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 3131157719093603387L;
    private final List<CommentPanel> commentPanels = Collections.synchronizedList(new ArrayList());
    private CommentPanel quoteCommentPanel;
    private CommentPanel deletedCommentPanel;
    private CommentPanel editedCommentPanel;
    public static final String PROP_COMMENT_DELETED = "github.issues.comment.deleted";
    public static final String PROP_COMMENT_QUOTE = "github.issues.comment.quote";
    public static final String PROP_COMMENT_EDITED = "github.issues.comment.edited";

    public CommentsPanel() {
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Comment> getComments() {
        ArrayList<Comment> comments = new ArrayList<Comment>(this.commentPanels.size());
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            for (CommentPanel commentPanel : this.commentPanels) {
                comments.add(commentPanel.getComment());
            }
        }
        return comments;
    }

    public void addComments(Collection<Comment> comments, GitHubRepository repository) {
        for (Comment comment : comments) {
            this.addComment(comment, repository);
        }
    }

    public void addComment(Comment comment, GitHubRepository repository) {
        if (comment == null || repository == null) {
            return;
        }
        GitHubCache cache = GitHubCache.create(repository);
        User owner = comment.getUser();
        String loginName = repository.getUserName();
        CommentPanel newPanel = new CommentPanel(comment, cache.getUserIcon(owner));
        boolean isMyself = this.isMyself(owner, loginName);
        newPanel.setEditEnabled(isMyself);
        newPanel.setDeleteEnabled(isMyself);
        newPanel.addPropertyChangeListener(this);
        this.commentPanels.add(newPanel);
        this.add(newPanel);
    }

    private boolean isMyself(User owner, String me) {
        if (owner == null || StringUtils.isEmpty(me)) {
            return false;
        }
        return owner.getLogin().equals(me);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllComments() {
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            for (CommentPanel comment : this.commentPanels) {
                this.removeComment(comment);
            }
            this.commentPanels.clear();
        }
    }

    private void removeComment(CommentPanel comment) {
        if (comment == null) {
            return;
        }
        comment.removePropertyChangeListener(this);
        this.remove(comment);
    }

    public String getQuoteComment() {
        if (this.quoteCommentPanel != null) {
            String selectedText = this.quoteCommentPanel.getSelectedText();
            if (StringUtils.isEmpty(selectedText)) {
                return this.quoteCommentPanel.getComment().getBody();
            }
            return selectedText;
        }
        return "";
    }

    public Comment getDeletedComment() {
        return this.deletedCommentPanel == null ? null : this.deletedCommentPanel.getComment();
    }

    public Comment getEditedComment() {
        return this.editedCommentPanel == null ? null : this.editedCommentPanel.getComment();
    }

    public void resetChangedPanels() {
        this.quoteCommentPanel = null;
        this.deletedCommentPanel = null;
        this.editedCommentPanel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadComments(GitHubRepository repository) {
        assert (repository != null);
        GitHubCache cache = GitHubCache.create(repository);
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            for (CommentPanel commentPanel : this.commentPanels) {
                Comment comment = commentPanel.getComment();
                User user = comment.getUser();
                commentPanel.load(cache.getUserIcon(user));
            }
        }
    }

    public void removeDeletedCommlent() {
        if (this.deletedCommentPanel != null) {
            this.deletedCommentPanel.setVisible(false);
            this.removeComment(this.deletedCommentPanel);
            this.deletedCommentPanel = null;
        }
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 3));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "github.issues.comment.quote": {
                this.fireQuotePropertyChanged();
                break;
            }
            case "github.issues.comment.deleted": {
                this.fireDeletedPropertyChanged();
                break;
            }
            case "github.issues.comment.edited": {
                this.fireEditedPropertyChanged();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQuotePropertyChanged() {
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            this.quoteCommentPanel = null;
            for (CommentPanel comment : this.commentPanels) {
                if (!comment.isQuote()) continue;
                this.quoteCommentPanel = comment;
                comment.resetProperties();
                this.firePropertyChange(PROP_COMMENT_QUOTE, null, null);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDeletedPropertyChanged() {
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            this.deletedCommentPanel = null;
            for (CommentPanel comment : this.commentPanels) {
                if (!comment.isDeleted()) continue;
                this.deletedCommentPanel = comment;
                comment.resetProperties();
                this.firePropertyChange(PROP_COMMENT_DELETED, null, null);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEditedPropertyChanged() {
        List<CommentPanel> list = this.commentPanels;
        synchronized (list) {
            this.editedCommentPanel = null;
            for (CommentPanel comment : this.commentPanels) {
                if (!comment.isEdited()) continue;
                this.editedCommentPanel = comment;
                comment.resetProperties();
                this.firePropertyChange(PROP_COMMENT_EDITED, null, null);
                break;
            }
        }
    }
}

