/*
 * Decompiled with CFR 0.152.
 */
package com.junichi11.netbeans.modules.github.issues.issue.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.eclipse.egit.github.core.Commit;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class CommitPanel
extends JPanel {
    private static final long serialVersionUID = -7750751673488101906L;
    private final Commit commit;
    private JLabel commiterLabel;
    private JLabel messageLabel;
    private JButton moreButton;
    private JLabel moreMessageLabel;

    public CommitPanel(Commit commit, Icon commiterIcon) {
        this.commit = commit;
        this.initComponents();
        this.setCommiter(commiterIcon);
        this.setMessage(commit.getMessage());
        Dimension dim = this.messageLabel.getPreferredSize();
        this.messageLabel.setMinimumSize(new Dimension(0, dim.height));
        this.messageLabel.setPreferredSize(new Dimension(0, dim.height));
    }

    public Commit getCommit() {
        return this.commit;
    }

    private void setCommiter(Icon commiterIcon) {
        this.commiterLabel.setText("");
        this.commiterLabel.setIcon(commiterIcon);
        this.commiterLabel.setToolTipText(this.commit.getCommitter().getName());
    }

    private void setMessage(String message) {
        String firstLineMessage;
        if (message == null) {
            message = "";
        }
        int indexOfLF = message.indexOf("\n");
        String moreMessage = null;
        if (indexOfLF != -1) {
            moreMessage = message.substring(indexOfLF + 1).trim();
            firstLineMessage = message.substring(0, indexOfLF);
        } else {
            firstLineMessage = message;
        }
        this.messageLabel.setText(firstLineMessage);
        this.messageLabel.setToolTipText(firstLineMessage);
        boolean hasMore = moreMessage != null && !moreMessage.isEmpty();
        this.moreButton.setVisible(hasMore);
        if (hasMore) {
            this.moreMessageLabel.setText("<html>" + moreMessage.replaceAll("\n", "<br />"));
        } else {
            this.moreMessageLabel.setText(" ");
        }
        this.moreMessageLabel.setVisible(false);
    }

    private void initComponents() {
        this.commiterLabel = new JLabel();
        this.messageLabel = new JLabel();
        this.moreMessageLabel = new JLabel();
        this.moreButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.commiterLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.commiterLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.messageLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.messageLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.moreMessageLabel, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.moreMessageLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(CommitPanel.class, (String)"CommitPanel.moreButton.text"));
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitPanel.this.moreButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.commiterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreButton).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.moreMessageLabel, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commiterLabel).addComponent(this.messageLabel).addComponent(this.moreButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreMessageLabel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void moreButtonActionPerformed(ActionEvent evt) {
        this.moreMessageLabel.setVisible(!this.moreMessageLabel.isVisible());
    }
}

